/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intino.konos.builder.codegeneration.swagger.SwaggerSpec;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.magritte.framework.Layer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenApiDescriptor {
    private final Service.REST service;
    private final List<Schema> schemas;

    public OpenApiDescriptor(Service.REST service) {
        this.service = service;
        this.schemas = new ArrayList<Schema>();
    }

    public String createJSONDescriptor() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this.create());
    }

    private SwaggerSpec create() {
        SwaggerSpec spec = new SwaggerSpec();
        spec.basePath = this.service.basePath().isEmpty() ? "/" : this.service.basePath() + this.version();
        spec.host = this.service.host().contains("{") ? "www.example.org" : this.service.host();
        spec.schemes = this.service.protocols().stream().map(Enum::name).collect(Collectors.toList());
        spec.paths = new LinkedHashMap<String, SwaggerSpec.Path>();
        spec.info = this.createInfo(this.service.info());
        for (Service.REST.Resource resource : this.service.resourceList()) {
            spec.paths.put(this.reformatPathParameters(resource.path()), this.createPath(resource));
        }
        spec.definitions = this.createDefinitions();
        if (this.service.authentication() != null) {
            if (this.service.authentication().isBasic()) {
                spec.securityDefinitions = new HashMap<String, SwaggerSpec.SecurityDefinition>();
                spec.securityDefinitions.put("basic", new SwaggerSpec.SecurityDefinition().type("basic"));
                spec.security = new ArrayList<SwaggerSpec.SecuritySchema>();
                spec.security.add(new SwaggerSpec.SecuritySchema().basic());
            } else if (this.service.authentication().isBearer()) {
                spec.securityDefinitions = new HashMap<String, SwaggerSpec.SecurityDefinition>();
                spec.securityDefinitions.put("ouath2", new SwaggerSpec.SecurityDefinition().type("oauth2"));
                spec.security = new ArrayList<SwaggerSpec.SecuritySchema>();
                spec.security.add(new SwaggerSpec.SecuritySchema().bearer());
            }
        }
        return spec;
    }

    private String reformatPathParameters(String path) {
        List<String> parameters = Commons.extractUrlPathParameters(path);
        for (String parameter : parameters) {
            path = path.replace(":" + parameter, "{" + parameter + "}");
        }
        return path;
    }

    private String version() {
        if (this.service.info() == null || this.service.info().version() == null) {
            return "";
        }
        return "/" + this.service.info().version();
    }

    private SwaggerSpec.Info createInfo(Service.REST.Info info) {
        return info == null ? null : new SwaggerSpec.Info(info.version(), info.title(), info.description(), info.termsOfService(), info.contact() == null ? null : new SwaggerSpec.Info.Contact(info.contact().name$(), info.contact().email(), info.contact().url()), info.license() == null ? null : new SwaggerSpec.Info.License(info.license().name$(), info.license().url()));
    }

    private SwaggerSpec.Path createPath(Service.REST.Resource resource) {
        SwaggerSpec.Path path = new SwaggerSpec.Path();
        for (Service.REST.Resource.Operation op : resource.operationList()) {
            SwaggerSpec.Path.Operation operation = new SwaggerSpec.Path.Operation();
            operation.description = op.description().isEmpty() ? null : op.description();
            operation.summary = op.summary().isEmpty() ? null : op.summary();
            operation.operationId = op.name$();
            operation.tags = op.tags().isEmpty() ? null : op.tags();
            operation.parameters = this.createParameters(op.parameterList());
            this.addResponse(operation.responses, op.response());
            this.addResponse(operation.responses, op.exceptionList());
            this.addOperationToPath(path, operation, ((Object)((Object)op)).getClass().getSimpleName());
        }
        return path;
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, Response response) {
        SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
        if (response != null) {
            swaggerResponse.description = response.description();
            if (response.isObject()) {
                swaggerResponse.schema = new SwaggerSpec.Schema(null, "#/definitions/" + response.asObject().schema().name$());
                this.schemas.add(response.asObject().schema());
            }
        }
        responses.put(response == null ? "200" : response.code(), swaggerResponse);
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, List<Exception> exceptions) {
        for (Exception exception : exceptions) {
            SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
            swaggerResponse.description = exception.description();
            if (exception.isObject()) {
                swaggerResponse.schema = new SwaggerSpec.Schema(null, "#/definitions/" + exception.asObject().schema().name$());
                this.schemas.add(exception.asObject().schema());
            }
            responses.put(exception.code().value(), swaggerResponse);
        }
    }

    private void addOperationToPath(SwaggerSpec.Path path, SwaggerSpec.Path.Operation operation, String name) {
        switch (name) {
            case "Get": {
                path.get = operation;
                break;
            }
            case "Post": {
                path.post = operation;
                break;
            }
            case "patch": {
                path.patch = operation;
                break;
            }
            case "Put": {
                path.put = operation;
                break;
            }
            case "Delete": {
                path.delete = operation;
                break;
            }
            default: {
                path.head = operation;
            }
        }
    }

    private List<SwaggerSpec.Path.Operation.Parameter> createParameters(List<Service.REST.Resource.Parameter> parameters) {
        ArrayList<SwaggerSpec.Path.Operation.Parameter> list = new ArrayList<SwaggerSpec.Path.Operation.Parameter>();
        for (Service.REST.Resource.Parameter parameter : parameters) {
            SwaggerSpec.Path.Operation.Parameter swaggerParameter = new SwaggerSpec.Path.Operation.Parameter();
            swaggerParameter.description = parameter.description();
            swaggerParameter.in = parameter.in().name();
            swaggerParameter.name = parameter.name$();
            swaggerParameter.type = this.parameterType(parameter.in(), parameter.asType());
            boolean bl = swaggerParameter.required = parameter.in() == Service.REST.Resource.Parameter.In.path || parameter.isRequired();
            if (parameter.isObject()) {
                this.schemas.add(parameter.asObject().schema());
                if (parameter.in() == Service.REST.Resource.Parameter.In.body) {
                    swaggerParameter.schema = new SwaggerSpec.Schema(null, "#/definitions/" + parameter.asObject().schema().name$());
                }
            }
            list.add(swaggerParameter);
        }
        return list.isEmpty() ? null : list;
    }

    private String parameterType(Service.REST.Resource.Parameter.In in, Data.Type typeData) {
        String type = typeData.type();
        if (typeData.i$(Data.LongInteger.class) || type.equals("java.time.Instant") || type.equalsIgnoreCase("double")) {
            return "number";
        }
        if (typeData.i$(Data.File.class) || type.endsWith("Resource")) {
            return "file";
        }
        if (type.equalsIgnoreCase("java.lang.enum")) {
            return "string";
        }
        if (type.equalsIgnoreCase("java.util.Date")) {
            return "integer";
        }
        if (typeData.i$(Data.Object.class)) {
            if (in == Service.REST.Resource.Parameter.In.body) {
                return null;
            }
            return "object";
        }
        if (type.equalsIgnoreCase("java.util.Map")) {
            if (in == Service.REST.Resource.Parameter.In.body) {
                return null;
            }
            return "object";
        }
        return type.toLowerCase();
    }

    private String transform(Data.Type typeData) {
        String type = typeData.type();
        if (typeData.i$(Data.LongInteger.class) || type.equals("java.time.Instant") || type.equalsIgnoreCase("double")) {
            return "number";
        }
        if (typeData.i$(Data.File.class) || type.endsWith("Resource")) {
            return "file";
        }
        if (type.equalsIgnoreCase("java.lang.enum")) {
            return "string";
        }
        if (typeData.i$(Data.Object.class)) {
            return "object";
        }
        return type.toLowerCase();
    }

    private Map<String, SwaggerSpec.Definition> createDefinitions() {
        LinkedHashMap<String, SwaggerSpec.Definition> map = new LinkedHashMap<String, SwaggerSpec.Definition>();
        for (Schema schema : this.schemas) {
            SwaggerSpec.Definition definition = new SwaggerSpec.Definition();
            definition.required = schema.attributeList().stream().filter(Schema.Attribute::isRequired).map(Layer::name$).collect(Collectors.toList());
            definition.properties = this.toMap(schema.attributeList());
            map.put(schema.name$(), definition);
        }
        return map;
    }

    private Map<String, SwaggerSpec.Definition.Property> toMap(List<Schema.Attribute> attributes) {
        LinkedHashMap<String, SwaggerSpec.Definition.Property> map = new LinkedHashMap<String, SwaggerSpec.Definition.Property>();
        for (Schema.Attribute attribute : attributes) {
            map.put(attribute.name$(), this.propertyFrom(attribute));
        }
        return map;
    }

    private SwaggerSpec.Definition.Property propertyFrom(Schema.Attribute attribute) {
        SwaggerSpec.Definition.Property property = new SwaggerSpec.Definition.Property();
        property.type = this.transform(attribute.asType());
        return property;
    }
}

