/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.ServiceTemplateProvider;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayListRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.ResourceListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.stream.Collectors;

public class ServiceListRenderer
extends UIRenderer {
    private final KonosGraph graph;

    public ServiceListRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.graph = graph;
    }

    @Override
    public void render() throws KonosException {
        for (Service service : this.graph.serviceList(Service::isUI).collect(Collectors.toList())) {
            this.processUIService(service.asUI());
        }
        new ResourceListRenderer(this.context, this.graph, Target.Owner).execute();
    }

    private void processUIService(Service.UI service) throws KonosException {
        this.context.webModuleDirectory(new File(this.context.configuration().moduleDirectory().getParentFile(), Formatters.camelCaseToSnakeCase().format((Object)service.name$()).toString()));
        new ServiceRenderer(this.context, service).execute();
        new DisplayListRenderer(this.context, service, this.templateProvider(), this.target).execute();
    }

    private TemplateProvider templateProvider() {
        return new ServiceTemplateProvider();
    }
}

