/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Display;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public abstract class ElementRenderer<C extends Layer>
extends UIRenderer {
    protected final C element;
    protected final TemplateProvider templateProvider;

    protected ElementRenderer(CompilationContext compilationContext, C element, TemplateProvider templateProvider, Target target) {
        super(compilationContext, target);
        this.element = element;
        this.templateProvider = templateProvider;
    }

    @Override
    public void execute() throws KonosException {
        File displayFile = Commons.javaFile(CodeGenerationHelper.displayFolder(this.gen(), this.typeOf((Layer)this.element), this.target), this.displayName(false));
        if (this.isRendered((Layer)this.element) && displayFile.exists()) {
            return;
        }
        this.registerOutputs();
        super.execute();
    }

    protected void registerOutputs() {
        if (!this.target.equals((Object)Target.Owner)) {
            return;
        }
        String type = this.typeOf((Layer)this.element);
        File displayFile = Commons.javaFile(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), this.displayName(false));
        File accessibleFile = Commons.javaFile(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), this.displayName(true));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)this.element), displayFile.getAbsolutePath()));
        if (this.element.i$(Display.Accessible.class)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)this.element), accessibleFile.getAbsolutePath()));
        }
    }

    protected final void write(FrameBuilder builder) {
        if (this.hasAbstractClass((Layer)this.element)) {
            this.writeSrc(builder);
        }
        this.writeGen(builder);
    }

    private void writeSrc(FrameBuilder builder) {
        String newDisplay = CodeGenerationHelper.displayFilename(this.element.name$(), builder.is("accessible") ? "Proxy" : "");
        Template template = this.srcTemplate(builder);
        String type = this.typeOf((Layer)this.element);
        if (template == null) {
            return;
        }
        File sourceFile = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (!sourceFile.exists()) {
            this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), newDisplay, template.render((Object)builder.toFrame()));
        } else {
            Updater updater = this.updater(newDisplay, sourceFile);
            if (updater != null) {
                updater.update();
            }
        }
    }

    private void writeGen(FrameBuilder builder) {
        Template template = this.genTemplate(builder);
        String type = this.typeOf((Layer)this.element);
        if (template == null) {
            return;
        }
        String newDisplay = this.displayName(builder.is("accessible"));
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), newDisplay, template.render((Object)builder.add("gen").toFrame()));
    }

    private String displayName(boolean accessible) {
        String suffix;
        String string = suffix = accessible ? "Proxy" : "";
        String abstractValue = accessible ? "" : (ElementHelper.isRoot(this.element) && this.hasAbstractClass((Layer)this.element) ? "Abstract" : "");
        return CodeGenerationHelper.displayFilename(StringHelper.snakeCaseToCamelCase((String)(abstractValue + Commons.firstUpperCase(this.element.name$()))), suffix);
    }

    public void writeFrame(File packageFolder, String name, String text) {
        try {
            packageFolder.mkdirs();
            File file = CodeGenerationHelper.fileOf(packageFolder, name, this.target);
            Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    protected abstract Updater updater(String var1, File var2);

    private Template srcTemplate(FrameBuilder builder) {
        return this.templateProvider.srcTemplate((Layer)this.element, builder);
    }

    private Template genTemplate(FrameBuilder builder) {
        return this.templateProvider.genTemplate((Layer)this.element, builder);
    }
}

