/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.rules;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.rules.NodeRule;
import java.util.List;
import java.util.stream.Collectors;

public class CheckFileParameter
implements NodeRule {
    private Cause cause;

    public boolean accept(Node node) {
        List files = node.components().stream().filter(n -> this.isParameter((Node)n) && n.appliedAspects().stream().anyMatch(f -> f.type().equals("File"))).collect(Collectors.toList());
        if (!(files.isEmpty() || this.parameterInForm((Node)files.get(0)) || this.parameterInBody((Node)files.get(0)))) {
            this.cause = Cause.FileParameterNotInForm;
            return false;
        }
        return true;
    }

    public String errorMessage() {
        return this.cause.message;
    }

    private boolean isParameter(Node component) {
        return component.type().equals("Service.REST.Resource.Parameter");
    }

    private boolean parameterInForm(Node node) {
        return "form".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private boolean parameterInBody(Node node) {
        return "body".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private Parameter parameter(Node node, String name) {
        return node.parameters().stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
    }

    private static enum Cause {
        FileParameterNotInForm("File parameters only can be added in form");

        private final String message;

        private Cause(String message) {
            this.message = message;
        }
    }
}

