/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ContinuousAxisTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("continuous"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.axes;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.Axis;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Axis {\n\n    public static final String AXIS_LABEL = \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\n    private static final class Singleton {\n        private static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" INSTANCE = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n    }\n\n\t// === STATIC METHODS === //\n\n    public static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" get() {\n    \treturn Singleton.INSTANCE;\n    }\n\n    public static String label() {\n    \treturn AXIS_LABEL;\n    }\n\n    public static int size() {\n    \treturn get().getSize();\n    }\n\n    public static Component component(String id) {\n    \treturn get().getComponent(id);\n    }\n\n    public static Component component(int index) {\n    \treturn get().getComponent(index);\n    }\n\n    public static List<Range> ranges() {\n        return get().getRanges();\n    }\n\n    public static Range rangeOf(final double value) {\n        final Range[] ranges = Singleton.INSTANCE.ranges;\n    \tint index = binarySearch(ranges, value);\n    \tindex = index < 0 ? (index + 1) * -1 : index;\n    \treturn ranges[index >= ranges.length ? ranges.length - 1 : index];\n    }\n\n    private static int binarySearch(final Range[] ranges, final double value) {\n    \tint low = 0;\n    \tint high = ranges.length - 1;\n\n    \twhile (low <= high) {\n    \t\tfinal int mid = (low + high) >>> 1;\n    \t\tfinal double midVal = ranges[mid].max;\n    \t\tfinal int comparison = Double.compare(midVal, value);\n\n    \t\tif (comparison < 0)\n    \t\t\tlow = mid + 1;\n    \t\telse if (comparison > 0)\n    \t\t\thigh = mid - 1;\n    \t\telse\n    \t\t\treturn mid;\n    \t}\n    \treturn -(low + 1);\n    }\n\n    // === === //\n\n\tprivate final Range[] ranges = new Range[")}).output(new Rule.Output[]{this.mark("rangeSize", new String[0])}).output(new Rule.Output[]{this.literal("];\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t")}).output(new Rule.Output[]{this.mark("range", new String[]{"init"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n    @Override\n\tpublic String getLabel() {\n\t\treturn AXIS_LABEL;\n\t}\n\n    @Override\n\tpublic Component getComponent(String id) {\n\t\treturn ranges[Integer.parseInt(id)];\n\t}\n\n\tpublic List<Range> getRanges() {\n\t\treturn new AbstractList<>() {\n\t\t\t@Override\n\t\t\tpublic Range get(int index) {\n\t\t\t\treturn ranges[index];\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic int size() {\n\t\t\t\treturn ranges.length;\n\t\t\t}\n\t\t};\n\t}\n\n\t@Override\n\tpublic Component getComponent(int index) {\n\t\treturn ranges[index];\n\t}\n\n\t@Override\n\tpublic int getSize() {\n\t\treturn ranges().size();\n\t}\n\n\t@Override\n\tpublic List<Range> getComponents() {\n\t\treturn ranges();\n\t}\n\n\t@Override\n\tpublic Stream<Range> toStream() {\n\t    return Arrays.stream(ranges);\n\t}\n\n\tpublic class Range implements Component {\n\n\t\tprivate final int index;\n\t\tprivate final double min;\n\t\tprivate final double max;\n\t\tprivate final String label;\n\n\t\tpublic Range(int index, double min, double max, String label) {\n\t\t\tthis.index = index;\n\t\t\tthis.min = min;\n\t\t\tthis.max = max;\n\t\t\tthis.label = label;\n\t\t}\n\n\t\tpublic double min() {\n\t\t\treturn min;\n\t\t}\n\n\t\tpublic double max() {\n\t\t\treturn max;\n\t\t}\n\n\t\t@Override\n\t\tpublic int index() {\n\t\t\treturn index;\n\t\t}\n\n\t\t@Override\n\t\tpublic String id() {\n\t\t\treturn label;\n\t\t}\n\n        @Override\n\t\tpublic String label() {\n\t\t\treturn label;\n\t\t}\n\n\t\t@Override\n\t\tpublic Axis axis() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".this;\n\t\t}\n\n\t    @Override\n\t    public boolean equals(Object o) {\n\t    \tif (this == o) return true;\n\t    \tif (o == null || getClass() != o.getClass()) return false;\n\t    \tRange range = (Range) o;\n\t    \treturn index == range.index;\n\t    }\n\n\t    @Override\n\t    public int hashCode() {\n\t    \treturn index;\n\t    }\n\n\t    @Override\n\t    public String toString() {\n\t    \treturn axis().getClass().getSimpleName()+\".Range{\" +\n\t    \t\t\t\"index=\" + index +\n\t    \t\t\t\", min=\" + min +\n\t    \t\t\t\", max=\" + max +\n\t    \t\t\t\", label='\" + label + \"'\" +\n\t    \t\t\t'}';\n\t    }\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"range", "lower"}), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MIN_VALUE, ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "upper"}), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MAX_VALUE, \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.type("range"), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "lower"}), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MIN_VALUE, ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", \"< ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "upper"}), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MAX_VALUE, \"> ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.type("range"), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(" - ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal("\");")})});
    }
}

