/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.facts;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.analytic.SchemaSerialBuilder;
import io.intino.konos.model.graph.Axis;
import io.intino.konos.model.graph.Cube;
import io.intino.konos.model.graph.SizedData;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FactRenderer {
    private static final Comparator<Cube.Fact.Column> COMPARATOR = (col1, col2) -> {
        if (col1.isVirtual() || col1.isId()) {
            return Integer.MIN_VALUE;
        }
        if (col2.isVirtual() || col2.isId()) {
            return Integer.MAX_VALUE;
        }
        return -Integer.compare(col1.asType().size(), col2.asType().size());
    };
    private final Map<String, Integer> axisSizes = new HashMap<String, Integer>();

    public void render(Cube cube, FrameBuilder fb) {
        SchemaSerialBuilder serialBuilder = new SchemaSerialBuilder();
        fb.add("id", (Object)this.idOf(cube.fact()).name$());
        this.calculateColumnSizes(cube.fact().columnList());
        int lastOffset = this.addAllColumns(cube, fb, serialBuilder);
        fb.add("size", (Object)this.calculateFactSize(lastOffset));
        fb.add("serialUUID", (Object)serialBuilder.buildSerialId().toString());
    }

    private int addAllColumns(Cube cube, FrameBuilder fb, SchemaSerialBuilder serialBuilder) {
        int offset = 0;
        List columns = cube.fact().columnList().stream().sorted(COMPARATOR).collect(Collectors.toList());
        for (Cube.Fact.Column column : columns) {
            if (column.isVirtual()) {
                this.addVirtualAttribute(cube, fb, column);
                continue;
            }
            offset = this.addFactAttribute(cube, fb, serialBuilder, offset, column);
        }
        return offset;
    }

    private void addVirtualAttribute(Cube cube, FrameBuilder fb, Cube.Fact.Column column) {
        SizedData.Type type = column.asType();
        String javaType = this.type(type);
        FrameBuilder columnFB = new FrameBuilder(new String[]{"virtualColumn"}).add("cube", (Object)cube.name$()).add("type", (Object)javaType).add("name", (Object)column.name$()).add("defaultValue", (Object)this.defaultValueOf(javaType));
        if (this.isPrimitive(type)) {
            columnFB.add("primitive");
        }
        fb.add("virtualColumn", (Object)columnFB);
    }

    private String defaultValueOf(String javaType) {
        switch (javaType) {
            case "byte": 
            case "short": 
            case "int": 
            case "long": {
                return "0";
            }
            case "float": {
                return "0.0f";
            }
            case "double": {
                return "0.0";
            }
        }
        return "null";
    }

    private int addFactAttribute(Cube cube, FrameBuilder fb, SchemaSerialBuilder serialBuilder, int offset, Cube.Fact.Column column) {
        int columnSize = column.asType().size();
        if (this.getMinimumBytesFor(offset, columnSize) > 8) {
            offset = this.roundUp2(offset, 64);
        }
        fb.add("column", (Object)this.columnFrame(column, offset, cube.name$()));
        serialBuilder.add(column.name$(), this.type(column.asType()), offset, column.asType().size());
        return offset + columnSize;
    }

    private int calculateFactSize(int offset) {
        return (int)Math.ceil((float)offset / 8.0f);
    }

    private FrameBuilder columnFrame(Cube.Fact.Column column, int offset, String cube) {
        if (column.isCategory()) {
            return this.processCategoryColumn(column.asCategory(), column.name$(), offset, cube);
        }
        return this.processColumn(column, offset, cube);
    }

    private FrameBuilder processColumn(Cube.Fact.Column column, int offset, String cube) {
        SizedData.Type type = column.asType();
        String javaType = this.type(type);
        String signType = column.isUnsignedInt() || column.isUnsignedLong() ? "unsigned" : "signed";
        FrameBuilder builder = new FrameBuilder(new String[]{"column", javaType, signType, column.core$().is(Cube.Fact.Attribute.class) ? "attribute" : "measure"}).add("owner", (Object)cube).add("name", (Object)((Cube.Fact.Column)column.a$(Cube.Fact.Column.class)).name$()).add("offset", (Object)offset).add("cube", (Object)cube).add("type", (Object)javaType);
        if (this.isAligned(javaType, offset, type.size())) {
            builder.add("aligned", (Object)"Aligned");
        } else {
            builder.add("bits", (Object)type.size());
        }
        builder.add("size", (Object)type.size());
        return builder;
    }

    private FrameBuilder processCategoryColumn(SizedData.Category column, String name, int offset, String cube) {
        Axis.Categorical axis = column.axis().asCategorical();
        return new FrameBuilder(new String[]{"column", "categorical"}).add("owner", (Object)cube).add("name", (Object)name).add("type", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("offset", (Object)offset).add("cube", (Object)cube).add("bits", (Object)column.asSizedData().asType().size());
    }

    private String type(SizedData.Type type) {
        if (type.i$(SizedData.Category.class)) {
            return type.name$();
        }
        return this.isPrimitive(type) ? this.asJavaType(type) : type.type();
    }

    private String asJavaType(SizedData.Type type) {
        String primitive = this.unboxed(type.primitive());
        if (primitive.equals("int")) {
            if (type.size() <= 8) {
                return "byte";
            }
            if (type.size() <= 16) {
                return "short";
            }
        } else if (primitive.equals("double") && type.size() <= 32) {
            return "float";
        }
        return primitive;
    }

    private String unboxed(String primitive) {
        switch (primitive) {
            case "Byte": {
                return "byte";
            }
            case "Short": {
                return "short";
            }
            case "Integer": {
                return "int";
            }
            case "Long": 
            case "LongInteger": {
                return "long";
            }
            case "Float": {
                return "float";
            }
            case "Double": {
                return "double";
            }
        }
        return primitive;
    }

    private int sizeOf(Axis.Categorical axis) {
        try {
            if (!this.axisSizes.containsKey(axis.name$())) {
                this.axisSizes.put(axis.name$(), (int)Math.ceil(this.log2(this.countLines(axis) + 1)));
            }
            return this.axisSizes.get(axis.name$());
        }
        catch (IOException e) {
            return 0;
        }
    }

    private boolean isAligned(String javaType, int offset, int size) {
        if (offset % size != 0) {
            return false;
        }
        return javaType.equals("int") && size == 32 || javaType.equals("short") && size == 16 || javaType.equals("byte") && size == 8 || javaType.equals("boolean") && size == 8 || javaType.equals("long") && size == 64 || javaType.equals("float") && size == 32 || javaType.equals("double") && size == 64;
    }

    private boolean isPrimitive(SizedData.Type attribute) {
        SizedData data = attribute.asSizedData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isId() || data.isReal();
    }

    private void calculateColumnSizes(List<Cube.Fact.Column> columns) {
        for (Cube.Fact.Column column : columns) {
            if (column.isVirtual() || !column.isCategory()) continue;
            column.asType().size(this.sizeOf(column.asCategory().axis().asCategorical()));
        }
    }

    private int getMinimumBytesFor(int bitIndex, int bitCount) {
        int bitOffset = this.offsetOf(bitIndex);
        int numBytes = (int)Math.ceil((double)(bitOffset + bitCount) / 8.0);
        return this.roundSize(numBytes);
    }

    private int roundSize(int n) {
        if (n == 1 || n == 2 || n == 4 || n == 8) {
            return n;
        }
        if (n < 4) {
            return 4;
        }
        return Math.max(n, 8);
    }

    private int offsetOf(int bitIndex) {
        return bitIndex % 8;
    }

    private int roundUp2(int n, int multiple) {
        return n + multiple - 1 & -multiple;
    }

    private int countLines(Axis.Categorical axis) throws IOException {
        return (int)new BufferedReader(new InputStreamReader(this.resource(axis))).lines().count();
    }

    public FileInputStream resource(Axis.Categorical axis) throws FileNotFoundException {
        return new FileInputStream(axis.tsv().getFile());
    }

    public double log2(int N) {
        return Math.log(N) / Math.log(2.0);
    }

    public Cube.Fact.Column idOf(Cube.Fact fact) {
        return fact.columnList().stream().filter(SizedData::isId).findFirst().orElse(null);
    }
}

