/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CubeTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"cube", "src"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes;\n\nimport io.intino.alexandria.led.buffers.store.ByteStore;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\n\nimport java.util.List;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<Loader> loaders) {\n\t\tsuper(loaders);\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customDimension", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customFilter", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tpublic static class Loader extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader {\n\n\t\tpublic Loader(Datasource datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tsuper(datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(");\n\t\t}\n\n\t\t// TODO write here a cache if necessary\n\t}\n\n\tpublic static class Fact extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".AbstractFact {\n\n\t    public Fact(ByteStore store) {\n\t        super(store);\n\t    }\n\n\t    ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("virtualColumn", new String[]{"implementation"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n}")}), this.rule().condition(this.type("cube"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes;\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.led.LedReader;\nimport io.intino.alexandria.led.LedStream;\nimport io.intino.alexandria.led.Schema;\nimport io.intino.alexandria.led.allocators.SchemaFactory;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\nimport io.intino.alexandria.led.util.iterators.MergedIterator;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.Axis;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Stream;\nimport java.util.stream.StreamSupport;\n\nimport static java.util.Comparator.comparingLong;\nimport static java.util.Spliterators.spliteratorUnknownSize;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact;\n\n@SuppressWarnings(\"unused\")\npublic abstract class Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Iterable<Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Aggregation> {\n\n\tpublic static final Fact NULL_FACT = new NullFact();\n\n\tprivate final List<? extends Loader> loaders;\n\tprivate Predicate<Fact> filter = fact -> true;\n\tprivate final List<Axis> axes = new ArrayList<>();\n\tprivate final Map<Axis, Set<Axis.Component>> components = new HashMap<>();\n\tprivate final List<Function<Fact, Axis.Component>> groupByList = new ArrayList<>();\n\tprivate Aggregation[] result;\n\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<? extends Loader> loaders) {\n\t\tthis.loaders = java.util.Objects.requireNonNull(loaders);\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dimension", new String[]{"method"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customFilter", new String[]{"method"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" execute() {\n\t\tresult = new Aggregation[resultsSize()];\n\t\tresults().forEach(this::append);\n\t\tfillCategories();\n\t\treturn this;\n\t}\n\n\tpublic Aggregation[] result() {\n        if(result == null) return new Aggregation[0];\n        return Arrays.stream(result).filter(java.util.Objects::nonNull).toArray(Aggregation[]::new);\n    }\n\n\t@Override\n\tpublic Iterator<Aggregation> iterator() {\n\t    return result == null\n            ? Stream.<Aggregation>empty().iterator()\n            : Arrays.stream(result).filter(java.util.Objects::nonNull).iterator();\n\t}\n\n\tpublic Iterator<Fact> detail() {\n\t\tMergedIterator<Fact> iterator = new MergedIterator<>(loaders.stream().map(Iterable::iterator), comparingLong(Fact::id));\n\t\treturn StreamSupport.stream(spliteratorUnknownSize(iterator, Spliterator.SORTED), false).filter(this::check).iterator();\n\t}\n\n\tpublic Aggregation aggregation(List<Axis.Component> components) {\n\t    final int index = indexOf(components);\n\t\treturn result[index];\n\t}\n\n    public Aggregation aggregation(Axis.Component... components) {\n        final int index = indexOf(components);\n    \treturn result[index];\n    }\n\n\tprivate void fillCategories() {\n\t\tfor (Aggregation aggregation : result) {\n\t\t\tif (aggregation == null) continue;\n\t\t\tfor (int i = 0; i < aggregation.components.length; i++)\n\t\t\t\tcomponents.get(axes.get(i)).add(aggregation.components[i]);\n\t\t}\n\t}\n\n\tprivate int resultsSize() {\n\t\tint accumulator = 1;\n\t\tfor (Axis axis : axes) accumulator *= axis.getSize() + 1;\n\t\treturn accumulator;\n\t}\n\n\tprivate Stream<Aggregation[]> results() {\n\t\treturn loaders.parallelStream().map(this::results);\n\t}\n\n\tprivate Aggregation[] results(Iterable<Fact> facts) {\n\t\tAggregation[] result = new Aggregation[resultsSize()];\n\t\tfor (Fact fact : facts) {\n\t\t    fact.setCube(this);\n\t\t\tif (!check(fact)) continue;\n\t\t\tAxis.Component[] components = componentsOf(fact);\n\t\t\tint index = indexOf(components);\n\t\t\tif (result[index] == null) result[index] = new Aggregation(components);\n\t\t\tresult[index].append(fact);\n\t\t}\n\t\treturn result;\n\t}\n\n\tprivate synchronized void append(Aggregation[] results) {\n\t\tfor (int i = 0; i < results.length; i++) {\n\t\t    final Aggregation aggregation = results[i];\n\t\t\tif (aggregation == null) continue;\n\t\t\tif (result[i] == null)\n                result[i] = aggregation;\n            else\n                result[i].append(aggregation);\n\t\t}\n\t}\n\n\tprivate int indexOf(Axis.Component[] components) {\n\t\tint index = 0;\n\t\tfor (int i = 0; i < components.length; i++) {\n\t\t\tindex *= axes.get(i).getSize();\n\t\t\tindex += components[i].index();\n\t\t}\n\t\treturn index;\n\t}\n\n\tprivate int indexOf(Collection<Axis.Component> components) {\n    \tint index = 0;\n    \tint i = 0;\n    \tfor (Axis.Component component : components) {\n    \t\tindex *= axes.get(i++).getSize();\n    \t\tindex += component.index();\n    \t}\n    \treturn index;\n    }\n\n\tprivate boolean check(Fact item) {\n\t    return filter.test(item);\n\t}\n\n\tprivate Axis.Component[] componentsOf(Fact item) {\n\t\tAxis.Component[] components = new Axis.Component[groupByList.size()];\n\t\tfor (int i = 0; i < components.length; i++) components[i] = groupByList.get(i).apply(item);\n\t\treturn components;\n\t}\n\n\tpublic static abstract class AbstractFact extends Schema {\n\n        public static final int SIZE = ")}).output(new Rule.Output[]{this.mark("size", new String[0])}).output(new Rule.Output[]{this.literal("; // Bytes\n        public static final UUID SERIAL_UUID = UUID.fromString(\"")}).output(new Rule.Output[]{this.mark("serialUUID", new String[0])}).output(new Rule.Output[]{this.literal("\");\n        public static final SchemaFactory<Fact> FACTORY = new SchemaFactory<>(Fact.class) {\n            @Override\n            public Fact newInstance(ByteStore store) {\n                return new Fact(store);\n            }\n        };\n\n        private Timetag timetag;\n        private Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube;\n\n        public AbstractFact(ByteStore store) {\n        \tsuper(store);\n        }\n\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("virtualColumn", new String[]{"abstract"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n        @Override\n        public long id() {\n        \treturn ")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("();\n        }\n\n        public final Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube() {\n            return cube;\n        }\n\n        void setCube(Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube) {\n            this.cube = cube;\n        }\n\n        public final Timetag timetag() {\n            return timetag;\n        }\n\n        void setTimetag(Timetag timetag) {\n            this.timetag = timetag;\n        }\n\n        @Override\n        public int size() {\n        \treturn SIZE;\n        }\n\n        @Override\n        public UUID serialUUID() {\n            return SERIAL_UUID;\n        }\n\n         @Override\n         public String toString() {\n             return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact{\"\n                     + \"id=\" + id()\n                     + \", timetag=\" + timetag()\n                     ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n                     + '}';\n         }\n    }\n\n\tpublic static class NullFact extends Fact {\n\n\t\tpublic static final int SIZE = Fact.SIZE; // Bytes\n\t\tpublic static final UUID SERIAL_UUID = Fact.SERIAL_UUID;\n        public static final SchemaFactory<NullFact> FACTORY = new SchemaFactory<>(NullFact.class) {\n            @Override\n        \tpublic NullFact newInstance(ByteStore store) {\n        \t    return new NullFact();\n        \t}\n        };\n\n\t\tprivate NullFact() {\n\t\t\tsuper(ByteStore.empty());\n\t\t}\n\n\t\t@Override\n\t\tpublic long id() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("();\n\t\t}\n\n\t\t@Override\n\t\tpublic int size() {\n\t\t\treturn SIZE;\n\t\t}\n\n\t\t@Override\n\t\tpublic UUID serialUUID() {\n\t\t    return SERIAL_UUID;\n\t\t}\n\t}\n\n\tpublic static class Aggregation {\n\n\t\tprivate final Axis.Component[] components;\n\t\tprivate long aggregationCount = 0;\n\t\t")}).output(new Rule.Output[]{this.mark("index", new String[]{"field"})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"field"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Aggregation(Axis.Component[] components) {\n\t\t\tthis.components = components;\n\t\t}\n\n\t\tpublic void append(Fact fact) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"sum"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\t")}).output(new Rule.Output[]{this.mark("index", new String[]{"append"})}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n\t\tpublic void append(Aggregation aggregation) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"sumAggregation"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\t")}).output(new Rule.Output[]{this.mark("index", new String[]{"append2"})}).output(new Rule.Output[]{this.literal("\n\t\t\taggregationCount += aggregation.aggregationCount;\n\t\t}\n\n\t\tpublic long aggregationCount() {\n\t\t\treturn aggregationCount;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.mark("index", new String[]{"getter"})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Axis.Component[] components() {\n\t\t\treturn components;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t    return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Aggregation{\"\n\t\t        + \"aggregationCount=\" + aggregationCount\n\t\t        ")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"toString"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t        + \"}\";\n\t\t}\n\t}\n\n\tpublic static abstract class Loader implements Iterable<Fact> {\n\n\t\tprotected final Datasource datasource;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[]{"field"})})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Loader(Datasource datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tthis.datasource = datasource;\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[]{"assign"})})}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n\t\t@Override\n\t\tpublic Iterator<Fact> iterator() {\n\t\t    return datasource.leds(")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})}).output(new Rule.Output[]{this.literal(").asJavaStream().iterator();\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[]{"method"})})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic static class Datasource {\n\n\t\t\tprivate final File root;\n\t\t\tprivate final Timetag from;\n\t\t\tprivate final Timetag to;\n\n\t\t\tpublic Datasource(File root, Timetag from, Timetag to) {\n\t\t\t\tthis.root = root;\n\t\t\t\tthis.from = from;\n\t\t\t\tthis.to = to;\n\t\t\t}\n\n\t\t\tpublic Timetag from() {\n\t\t\t\treturn from;\n\t\t\t}\n\n\t\t\tpublic Timetag to() {\n\t\t\t\treturn to;\n\t\t\t}\n\n\t\t\tprivate LedStream<Fact> leds(")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})}).output(new Rule.Output[]{this.literal(") {\n\t\t\t\treturn LedStream.merged(StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(t -> on(t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(")));\n\t\t\t}\n\n\t\t\tprivate LedStream<Fact> on(Timetag timetag")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})})}).output(new Rule.Output[]{this.literal(") {\n\t\t\t\tFile file = new File(root + \"/")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\" ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("+ \".\" + ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(", timetag.value() + \".led\");\n\t\t\t\tLedStream<Fact> facts = file.exists() ? new LedReader(file).read(Fact.class) : LedStream.empty(Fact.class);\n\t\t\t\treturn facts.peek(fact -> fact.setTimetag(timetag));\n\t\t\t}\n\t\t}\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"index", "total"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("private long aggregationTotal = 0;\nprivate long last = 0;")}), this.rule().condition(this.allTypes(new String[]{"index", "total"}), new Rule.Condition[]{this.trigger("append")}).output(new Rule.Output[]{this.literal("if (last != fact.id()) {\n\t++aggregationCount;\n\tlast = fact.id();\n}\n++aggregationTotal;")}), this.rule().condition(this.allTypes(new String[]{"index", "total"}), new Rule.Condition[]{this.trigger("append2")}).output(new Rule.Output[]{this.literal("aggregationTotal += aggregation.aggregationTotal;")}), this.rule().condition(this.allTypes(new String[]{"index", "total"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public long aggregationTotal() {\n\treturn aggregationTotal;\n}")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("private final io.intino.alexandria.led.util.collections.SparseLongList ids = new io.intino.alexandria.led.util.collections.SparseLongList();")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("append")}).output(new Rule.Output[]{this.literal("if (ids.isEmpty() || ids.get(ids.size() - 1) != fact.id()) ids.add(fact.id());")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("append2")}).output(new Rule.Output[]{this.literal("ids.addAll(aggregation.ids);")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public List<Long> ids() {\n\treturn ids.asList();\n}")}), this.rule().condition(this.trigger("nbits"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("NBits")}), this.rule().condition(this.type("customFilter"), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n    filter = filter.and(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter);\n\treturn this;\n}")}), this.rule().condition(this.type("customFilter"), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact) {\n\t// TODO: write here your code\n\treturn true;\n}")}), this.rule().condition(this.type("customDimension"), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("isDistribution", new String[0])}).output(new Rule.Output[]{this.literal("Range")})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function() {\n    // TODO: write here your code\n\treturn v -> null;\n}")}), this.rule().condition(this.allTypes(new String[]{"dimension", "categorical"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tfilter = filter.and(v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("));\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function);\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}\n\npublic static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\treturn fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("child", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.allTypes(new String[]{"dimension", "continuous"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tfilter = filter.and(v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("));\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function);\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}\n\nprivate static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".rangeOf(fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("());\n}")}), this.rule().condition(this.allTypes(new String[]{"customDimension", "continuous"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(".Range> ranges) {//TODO\n\tfilter = filter.and(v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ranges));\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(".get);\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(".get, new HashSet<>());\n\tgroupByList.add(Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function);\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(".Range> rangos) {\n\treturn rangos.contains(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("tostring")}).output(new Rule.Output[]{this.literal(" + \", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("=\" + ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("sum")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("sumaggregation")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" / (double) ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.type("total"), new Rule.Condition[]{this.trigger("index")}).output(new Rule.Output[]{this.literal("aggregationTotal")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("index")}).output(new Rule.Output[]{this.literal("ids.size()")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static double ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(Fact fact) {\n\treturn 0.;\n}")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static long ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(Fact fact) {\n\treturn 0;\n}")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.literal("String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("setparameter")}).output(new Rule.Output[]{this.literal("Set<String> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("nameupper")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected final String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("private static Set<String> all")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn java.util.Set.of(")}).output(new Rule.Output[]{this.mark("value", new String[]{"quoted"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("ifgroupby")}).output(new Rule.Output[]{this.literal("if(axis.equals(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("iffilterby")}).output(new Rule.Output[]{this.literal("if(axis.equals(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.trigger("dimension"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static Predicate<")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("List) {\n\treturn r -> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("List.contains(r.")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("());\n}\n\npublic static Function<")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact, String> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn r -> r.")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().id();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.trigger("tostring")}).output(new Rule.Output[]{this.literal("+ \", ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("=\" + ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("()")})});
    }
}

