/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CategoricalAxisTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("axis"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.axes;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.Axis;\n\nimport java.util.*;\nimport java.util.stream.Stream;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\nimport java.util.concurrent.atomic.AtomicInteger;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Axis {\n\n    public static final Component NA = new Component(0, \"NA\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[]{"defaultValue"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");\n    ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("component", new String[0]).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n    private static final class Singleton {\n    \tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" INSTANCE = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n    }\n\n    // === STATIC METHODS === //\n\n    public static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" get() {\n    \treturn Singleton.INSTANCE;\n    }\n\n\tpublic static String label() {\n\t\treturn get().getLabel();\n\t}\n\n\tpublic static int size() {\n\t\treturn get().getSize();\n\t}\n\n    public static List<Component> components() {\n    \treturn get().getComponents();\n    }\n\n    public static Stream<Component> stream() {\n    \treturn get().toStream();\n    }\n\n    public static List<Component> components(Predicate<Component> filter) {\n    \treturn get().getComponents(filter);\n    }\n\n    public static Component component(int index) {\n    \treturn get().getComponent(index);\n    }\n\n    public static Component component(String name) {\n    \treturn get().getComponent(name);\n    }\n\n    // === === //\n\n\tprivate final Component[] components;\n\tprivate final Map<String, Component> componentsByName;\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\tthis.componentsByName = new WeakHashMap<>();\n\t    ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("components", new String[]{"load"})})}).output(new Rule.Output[]{this.literal("\n\t}\n\n    @Override\n\tpublic String getLabel() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t}\n\n    @Override\n\tpublic int getSize() {\n\t\treturn components.length - 1;\n\t}\n\n    @Override\n    public List<Component> getComponents() {\n    \treturn new AbstractList<>() {\n    \t\t@Override\n    \t\tpublic Component get(int index) {\n    \t\t\treturn component(index + 1);\n    \t\t}\n    \t\t@Override\n    \t\tpublic int size() {\n    \t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".size();\n    \t\t}\n    \t};\n    }\n\n    @Override\n    public Stream<Component> toStream() {\n    \treturn Arrays.stream(components).skip(1);\n    }\n\n    public List<Component> getComponents(Predicate<Component> filter) {\n    \treturn stream().filter(filter).collect(Collectors.toList());\n    }\n\n    @Override\n    public Component getComponent(int index) {\n    \treturn (index <= 0 || index > size()) ? NA : components[index];\n    }\n\n    @Override\n    public Component getComponent(String name) {\n    \tif(!componentsByName.containsKey(name))\n    \t\tcomponentsByName.put(name, stream().filter(c -> c.label().equals(name)).findAny().orElse(NA));\n    \treturn componentsByName.getOrDefault(name, NA);\n    }\n\n\n\tpublic static class Component implements Axis.Component {\n\n\t\tpublic final int index;\n\t\tpublic final String id;\n\t\t")}).output(new Rule.Output[]{this.mark("include", new String[]{"declaration"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tComponent(int index, String id")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[]{"parameter"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tthis.index = index;\n\t\t\tthis.id = id;\n\t\t\t")}).output(new Rule.Output[]{this.mark("include", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n        @Override\n\t\tpublic int index() {\n\t\t\treturn index;\n\t\t}\n\n        @Override\n\t\tpublic String id() {\n\t\t\treturn id;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("include", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n        @Override\n\t\tpublic Axis axis() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".get();\n\t\t}\n\n\t    @Override\n\t    public boolean equals(Object o) {\n\t    \tif (this == o) return true;\n\t    \tif (o == null || getClass() != o.getClass()) return false;\n\t    \tComponent component = (Component) o;\n\t    \treturn index == component.index;\n\t    }\n\n\t    @Override\n\t    public int hashCode() {\n\t    \treturn Objects.hash(index, id);\n\t    }\n\n\t    @Override\n\t    public String toString() {\n\t        StringBuilder sb = new StringBuilder(axis().getClass().getSimpleName());\n\t        sb.append('{');\n\t        sb.append(\"index=\").append(index);\n\t        sb.append(\", id=\").append(id);\n\t        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("include", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t        return sb.append('}').toString();\n\t    }\n\t}\n}")}), this.rule().condition(this.type("component"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static final Component ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" = new Component(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\"")})}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[0]).multiple(", ")})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("declaration")}).output(new Rule.Output[]{this.literal("public final String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("declaration"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n    return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n    return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.trigger("tostring"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("sb.append(\", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("=\").append(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("\"\"")}), this.rule().condition(this.trigger("defaultvalue"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.literal("String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.trigger("parameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] : \"NA\"")}), this.rule().condition(this.trigger("constructor"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA")}), this.rule().condition(this.trigger("assign"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("put"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("components.put(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");\ncomponentsByName.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.trigger("field"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static final Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" = new Component(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\"")})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.type("components"), new Rule.Condition[]{this.attribute("embedded", "true"), this.trigger("load")}).output(new Rule.Output[]{this.literal("this.components = new Component[] {NA")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("component", new String[0]).multiple(", ")})}).output(new Rule.Output[]{this.literal("};")}), this.rule().condition(this.type("components"), new Rule.Condition[]{this.attribute("embedded", "false"), this.trigger("load")}).output(new Rule.Output[]{this.literal("Component[] components = new Component[0];\njava.io.InputStream resource = getClass().getResourceAsStream(\"")}).output(new Rule.Output[]{this.mark("resource", new String[0])}).output(new Rule.Output[]{this.literal("\");\nif(resource == null) throw new IllegalStateException(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(": Resource \" + \"")}).output(new Rule.Output[]{this.mark("resource", new String[0])}).output(new Rule.Output[]{this.literal("\" + \" not found\");\ntry (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(resource))) {\n\t\tcomponents = Stream.concat(Stream.of(NA),\n\t\treader.lines().map(l -> l.split(\"\t\")).map(l -> new Component(Integer.parseInt(l[0]),l[1]")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(",")}).output(new Rule.Output[]{this.mark("include", new String[]{"constructor"}).multiple(", ")})}).output(new Rule.Output[]{this.literal("))\n\t\t).toArray(Component[]::new);\n\t} catch (Exception e) {\n\t\tio.intino.alexandria.logger.Logger.error(\"Failed to load components of ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("\", e);\n\t}\n\tthis.components = components;")})});
    }
}

