/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.analytic.BuilderTemplate;
import io.intino.konos.builder.codegeneration.accessor.analytic.CubeWithSettersTemplate;
import io.intino.konos.builder.codegeneration.analytic.AxisInterfaceRenderer;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisRenderer;
import io.intino.konos.builder.codegeneration.facts.FactRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Axis;
import io.intino.konos.model.graph.Cube;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;

public class AnalyticBuilderRenderer
extends Renderer {
    private final KonosGraph graph;
    private final File destination;
    private final String packageName;
    private final FactRenderer factRenderer;
    private final CategoricalAxisRenderer categoricalAxisRenderer;
    private final ContinuousAxisRenderer continuousAxisRenderer;

    public AnalyticBuilderRenderer(CompilationContext compilationContext, KonosGraph graph, File destination) {
        super(compilationContext, Target.Owner);
        this.graph = graph;
        this.destination = destination;
        this.destination.mkdirs();
        this.packageName = compilationContext.packageName();
        this.factRenderer = new FactRenderer();
        File res = this.context.res(Target.Owner).getAbsoluteFile();
        this.categoricalAxisRenderer = new CategoricalAxisRenderer(this.context, destination, res);
        this.continuousAxisRenderer = new ContinuousAxisRenderer(this.context, destination);
    }

    @Override
    public void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph);
        this.renderBuilder(this.graph);
    }

    private void renderAxes(List<Axis> axes) {
        if (axes.isEmpty()) {
            return;
        }
        AxisInterfaceRenderer.render(this.destination, this.context);
        axes.stream().filter(Axis::isCategorical).map(Axis::asCategorical).forEach(this.categoricalAxisRenderer::render);
        axes.stream().filter(Axis::isContinuous).map(Axis::asContinuous).forEach(this.continuousAxisRenderer::render);
    }

    private void renderCubes(KonosGraph graph) {
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> Commons.writeFrame(new File(this.destinationDirectory(), "cubes"), cube.name$(), this.cubeTemplate().render((Object)this.renderCube((Cube)((Object)cube)).toFrame())));
    }

    private FrameBuilder renderCube(Cube cube) {
        FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.packageName).add("name", (Object)cube.name$());
        this.factRenderer.render(cube, fb);
        return fb;
    }

    private void renderBuilder(KonosGraph graph) {
        FrameBuilder builder = new FrameBuilder(new String[]{"builder"}).add("package", (Object)this.packageName).add("name", (Object)(this.context.boxName() + "AnalyticBuilder"));
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> builder.add("cube", (Object)this.renderCube((Cube)((Object)cube))));
        Commons.writeFrame(this.destinationDirectory(), this.context.boxName() + "AnalyticBuilder", this.builderTemplate().render((Object)builder.toFrame()));
    }

    private File destinationDirectory() {
        return new File(this.destination, this.packageName.replace(".", "/") + "/analytic");
    }

    private Template builderTemplate() {
        return Formatters.customize(new BuilderTemplate());
    }

    private Template cubeTemplate() {
        return Formatters.customize(new CubeWithSettersTemplate());
    }
}

