/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Axis;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CategoricalAxisRenderer {
    public static final int LABEL_INDEX = 2;
    public static final int MAX_EMBEDDED_COMPONENTS = 100;
    private final CompilationContext context;
    private final File gen;
    private final File res;

    public CategoricalAxisRenderer(CompilationContext context, File gen, File res) {
        this.context = context;
        this.gen = gen;
        this.res = res;
    }

    public void render(Axis.Categorical axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"axis"});
        this.addBasicAxisInfo(fb, axis);
        this.handleIncludes(fb, axis);
        this.writeAxisFrame(fb, axis);
        this.addToCompiledFiles(axis);
    }

    private void addBasicAxisInfo(FrameBuilder fb, Axis.Categorical axis) {
        fb.add("package", (Object)this.context.packageName()).add("name", (Object)axis.name$()).add("label", (Object)axis.label());
        if (axis.asAxis().isDynamic()) {
            fb.add("dynamic", (Object)";");
        }
    }

    private void writeAxisFrame(FrameBuilder fb, Axis.Categorical axis) {
        Commons.writeFrame(new File(this.gen, "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()), Formatters.customize(new CategoricalAxisTemplate()).render((Object)fb.toFrame()));
    }

    private void addToCompiledFiles(Axis.Categorical axis) {
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axis), Commons.javaFile(new File(this.gen, "axes"), this.getJavaFilename(axis)).getAbsolutePath()));
    }

    private void handleIncludes(FrameBuilder fb, Axis.Categorical axis) {
        this.addLabel(fb, axis);
        List<Axis> includes = axis.include() == null ? Collections.emptyList() : axis.include().axes();
        this.loadComponents(fb, axis, includes);
        this.addIncludes(fb, axis, includes);
    }

    private void addLabel(FrameBuilder fb, Axis.Categorical axis) {
        if (axis.includeLabel() != null) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)"label").add("index", (Object)2));
        }
    }

    private void addIncludes(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes) {
        int offset = this.offset(axis);
        for (int i = 0; i < includes.size(); ++i) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)includes.get(i).name$()).add("index", (Object)(i + offset)));
        }
    }

    private void loadComponents(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes) {
        String resource = this.axisResource(axis.tsv().getPath());
        List<ComponentInfo> components = this.loadFromResource(resource);
        boolean embedded = this.isSmallEnough(components);
        if (embedded) {
            this.createEmbeddedComponents(fb, axis, includes, components);
        }
        FrameBuilder componentsFB = new FrameBuilder(new String[]{"components"});
        componentsFB.add("embedded", (Object)embedded);
        if (embedded) {
            this.addEmbeddedComponentsToArray(componentsFB, axis, components);
        } else {
            componentsFB.add("resource", (Object)resource);
        }
        this.addLabel(componentsFB, axis);
        this.addIncludes(componentsFB, axis, includes);
        fb.add("components", (Object)componentsFB);
    }

    private void addEmbeddedComponentsToArray(FrameBuilder fb, Axis.Categorical axis, List<ComponentInfo> components) {
        boolean hasLabel = axis.includeLabel() != null;
        for (ComponentInfo component : components) {
            String name = hasLabel ? component.label() : component.id();
            fb.add("component", (Object)this.asFieldName(name));
        }
    }

    private void createEmbeddedComponents(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes, List<ComponentInfo> components) {
        for (ComponentInfo component : components) {
            FrameBuilder compFB = new FrameBuilder(new String[]{"component"});
            boolean hasLabel = axis.includeLabel() != null;
            String name = hasLabel ? component.label() : component.id();
            compFB.add("name", (Object)this.asFieldName(name));
            if (hasLabel) {
                compFB.add("label", (Object)component.label());
            }
            compFB.add("index", (Object)component.index());
            compFB.add("id", (Object)component.id());
            this.addIncludes(compFB, axis, includes);
            fb.add("component", (Object)compFB);
        }
    }

    private String asFieldName(String id) {
        return Character.isDigit((id = id.replaceAll("\\s+", "_").replace('-', '_')).charAt(0)) ? "_" + id : id;
    }

    private boolean isSmallEnough(List<ComponentInfo> components) {
        return components.size() <= 100;
    }

    private List<ComponentInfo> loadFromResource(String resource) {
        List<ComponentInfo> list;
        String fullResourcePath = new File(this.res, resource).getAbsolutePath();
        BufferedReader reader = new BufferedReader(new FileReader(fullResourcePath));
        try {
            list = reader.lines().map(line -> line.split("\t")).map(ComponentInfo::new).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private String axisResource(String resource) {
        Path res = this.context.res(Target.Owner).toPath();
        return res.relativize(new File(resource).toPath().toAbsolutePath()).toFile().getPath().replace("\\", "/");
    }

    private int offset(Axis.Categorical axis) {
        return axis.includeLabel() != null ? 3 : 2;
    }

    private String getJavaFilename(Axis.Categorical axis) {
        return Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString());
    }

    private static class ComponentInfo {
        private final String[] fields;

        public ComponentInfo(String[] fields) {
            this.fields = fields;
        }

        public int index() {
            return Integer.parseInt(this.field(0));
        }

        public String id() {
            return this.field(1);
        }

        public String field(int index) {
            return this.fields[index];
        }

        public String label() {
            return this.fields[2];
        }
    }
}

