/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.analytic.AxisInterfaceRenderer;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.CubeWithGettersTemplate;
import io.intino.konos.builder.codegeneration.analytic.VirtualCubeTemplate;
import io.intino.konos.builder.codegeneration.facts.FactRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Axis;
import io.intino.konos.model.graph.Cube;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;

public class AnalyticRenderer
extends Renderer {
    private final File src;
    private final File gen;
    private final KonosGraph graph;
    private final FactRenderer factRenderer;
    private final CategoricalAxisRenderer categoricalAxisRenderer;
    private final ContinuousAxisRenderer continuousAxisRenderer;

    public AnalyticRenderer(CompilationContext context, KonosGraph graph) {
        super(context, Target.Owner);
        this.src = new File(context.src(Target.Owner), "analytic");
        this.gen = new File(context.gen(Target.Owner), "analytic");
        File res = context.res(Target.Owner).getAbsoluteFile();
        this.graph = graph;
        this.factRenderer = new FactRenderer();
        this.categoricalAxisRenderer = new CategoricalAxisRenderer(context, this.gen, res);
        this.continuousAxisRenderer = new ContinuousAxisRenderer(context, this.gen);
    }

    @Override
    protected void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph.cubeList());
    }

    private void renderAxes(List<Axis> axes) {
        if (axes.isEmpty()) {
            return;
        }
        AxisInterfaceRenderer.render(this.gen, this.context);
        for (Axis axis : axes) {
            if (axis.isCategorical()) {
                this.categoricalAxisRenderer.render(axis.asCategorical());
                continue;
            }
            this.continuousAxisRenderer.render(axis.asContinuous());
        }
    }

    private void renderCubes(List<Cube> cubeList) {
        for (Cube cube : cubeList) {
            FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.context.packageName()).add("name", (Object)cube.name$());
            if (cube.isVirtual()) {
                this.renderVirtualCube(cube.asVirtual(), fb);
                continue;
            }
            this.renderCube(cube, fb);
        }
    }

    private void renderCube(Cube cube, FrameBuilder fb) {
        this.addDimensionsAndIndicators(cube, null, fb);
        if (cube.splitted() != null) {
            this.addSplit(cube, fb);
        }
        fb.add("index", (Object)new FrameBuilder(new String[]{"index", cube.index() != null ? "normal" : "total"}).add("value", (Object)""));
        this.factRenderer.render(cube, fb);
        this.write(cube, fb);
    }

    private void renderVirtualCube(Cube.Virtual virtualCube, FrameBuilder fb) {
        for (Cube reference : new Cube[]{virtualCube.main(), virtualCube.join()}) {
            this.addDimensionsAndIndicators(reference, virtualCube.asCube(), fb);
            this.factRenderer.render(reference, fb);
        }
        fb.add("index", (Object)new FrameBuilder(new String[]{"index", virtualCube.index() != null ? "index" : "total"}).add("value", (Object)""));
        fb.add("mainCube", (Object)virtualCube.main().name$());
        fb.add("joinCube", (Object)virtualCube.join().name$());
        fb.add("cube", (Object)new String[]{virtualCube.main().name$(), virtualCube.join().name$()});
        if (virtualCube.main().splitted() != null) {
            this.addSplit(virtualCube.main(), fb);
        }
        this.write(virtualCube.asCube(), fb);
    }

    private void write(Cube cube, FrameBuilder fb) {
        Template template = Formatters.customize(this.template(cube));
        Commons.writeFrame(new File(this.gen, "cubes"), "Abstract" + Commons.firstUpperCase(cube.name$()), template.render((Object)fb.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(cube), Commons.javaFile(new File(this.gen, "cubes"), "Abstract" + Commons.firstUpperCase(cube.name$())).getAbsolutePath()));
        if (this.alreadyRendered(new File(this.src, "cubes"), cube.name$())) {
            return;
        }
        Commons.writeFrame(new File(this.src, "cubes"), cube.name$(), template.render((Object)fb.add("src").toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(cube), Commons.javaFile(new File(this.src, "cubes"), Commons.firstUpperCase(cube.name$())).getAbsolutePath()));
    }

    private void addSplit(Cube cube, FrameBuilder fb) {
        fb.add("split", (Object)new FrameBuilder(new String[]{"split"}).add("name", (Object)cube.splitted().name$()).add("value", (Object)cube.splitted().splits().toArray(new String[0])));
    }

    private Template template(Cube cube) {
        return cube.isVirtual() ? new VirtualCubeTemplate() : new CubeWithGettersTemplate();
    }

    private void addDimensionsAndIndicators(Cube cube, Cube sourceCube, FrameBuilder fb) {
        cube.dimensionList().forEach(selector -> fb.add("dimension", (Object)this.dimensionFrame(cube, sourceCube, (Cube.Dimension)((Object)selector))));
        cube.indicatorList().forEach(indicator -> fb.add("indicator", (Object)this.indicatorFrame(cube, sourceCube, (Cube.Indicator)((Object)indicator))));
        for (Cube.CustomFilter customFilter : cube.customFilterList()) {
            fb.add("customFilter", (Object)new FrameBuilder(new String[]{"customFilter"}).add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)customFilter.name$()));
        }
    }

    private FrameBuilder dimensionFrame(Cube cube, Cube sourceCube, Cube.Dimension dimension) {
        FrameBuilder fb = new FrameBuilder(new String[]{"dimension", dimension.axis().core$().is(Axis.Categorical.class) ? "categorical" : "continuous"}).add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)dimension.name$()).add("source", (Object)dimension.attribute().name$()).add("axis", (Object)dimension.axis().name$());
        if (dimension.axis().i$(Axis.Categorical.class)) {
            fb.add("type", (Object)dimension.axis().name$());
            if (!((Object)((Object)dimension.attribute().asCategory().axis())).equals((Object)dimension.axis())) {
                fb.add("child", (Object)dimension.axis().name$());
            }
        }
        return fb;
    }

    private FrameBuilder indicatorFrame(Cube cube, Cube sourceCube, Cube.Indicator indicator) {
        return new FrameBuilder(new String[]{"indicator"}).add(indicator.isAverage() ? "average" : "sum").add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)indicator.name$()).add("label", (Object)indicator.label()).add("index", (Object)new FrameBuilder(new String[]{sourceCube == null && cube.index() != null || sourceCube != null && sourceCube.index() != null ? "index" : "total"})).add("source", (Object)indicator.source().name$()).add("unit", (Object)indicator.unit());
    }

    private boolean alreadyRendered(File destination, String name) {
        return Commons.javaFile(destination, name).exists();
    }
}

