/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class BuilderTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("builder"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic.cubes.*;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.Fingerprint;\nimport io.intino.alexandria.led.Schema;\n\nimport java.util.function.Consumer;\nimport java.util.function.Function;\nimport java.io.File;\nimport java.util.Objects;\n\nimport org.apache.commons.io.FileUtils;\nimport java.util.List;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tprivate final File destination;\n\tprivate final File stage;\n\tprivate Session session;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(File destination) {\n\t\tthis(destination, 1_000_000);\n\t}\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(File destination, int factBufferSise) {\n\t\tthis.destination = destination;\n\t\tthis.stage = new File(destination, \"session\" + java.util.UUID.randomUUID().toString());\n\t\tthis.session = new Session(destination, factBufferSise);\n\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("cube", new String[]{"put"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic void flush() {\n\t\tsession.close();\n\t}\n\n\tpublic void finish() {\n\t\tsession.close();\n\t\tmake();\n\t\ttry {\n\t\t\tFileUtils.deleteDirectory(stage);\n\t\t} catch (java.io.IOException e) {\n\t\t\tLogger.error(e);\n\t\t}\n\t}\n\n\tprivate void make() {\n\t\tFile[] files = FileUtils.listFiles(stage, new String[]{\"led\"}, true).toArray(new File[0]);\n\t\tio.intino.alexandria.led.util.LedSessionSorter.sort(files, (Function<File, File>) f -> datamartFile(Session.cleanedNameOf(f)), tempFolder());\n\t}\n\n\tprivate File datamartFile(String name) {\n\t\tFile ledFile = new File(destination, name + \".led\");\n\t\tledFile.getParentFile().mkdirs();\n\t\treturn ledFile;\n\t}\n\n\tprivate File tempFolder() {\n\t\tFile temp = new File(this.stage, \"temp\");\n\t\ttemp.mkdir();\n\t\treturn temp;\n\t}\n\n\tprivate static class Session {\n\t\tprivate final File root;\n\t\tprivate final java.util.Map<Fingerprint, io.intino.alexandria.led.UnsortedLedStreamBuilder<? extends io.intino.alexandria.led.Schema>> builders;\n\t\tprivate final int ledBufferSize;\n\n\t\tpublic Session(File root, int ledBufferSize) {\n\t\t\tthis.root = root;\n\t\t\tthis.ledBufferSize = ledBufferSize;\n\t\t\tthis.builders = new java.util.HashMap();\n\t\t}\n\n\t\tpublic <T extends io.intino.alexandria.led.Schema> void put(String tank, Timetag timetag, Class<T> schemaClass, java.util.stream.Stream<Consumer<T>> stream) {\n\t\t\tio.intino.alexandria.led.LedStream.Builder<T> builder = this.builder(Fingerprint.of(tank, timetag), schemaClass);\n\t\t\tObjects.requireNonNull(builder);\n\t\t\tstream.forEach(builder::append);\n\t\t}\n\n\t\tpublic <T extends io.intino.alexandria.led.Schema> void put(String tank, Timetag timetag, Class<T> schemaClass, Consumer<T> transaction) {\n\t\t\tio.intino.alexandria.led.LedStream.Builder<T> builder = this.builder(Fingerprint.of(tank, timetag), schemaClass);\n\t\t\tbuilder.append(transaction);\n\t\t}\n\n\t\tpublic void close() {\n\t\t\tthis.builders.forEach((f, b) -> {\n\t\t\t\tb.close();\n\t\t\t});\n\t\t}\n\n\t\tprivate <T extends io.intino.alexandria.led.Schema> io.intino.alexandria.led.LedStream.Builder<T> builder(Fingerprint fingerprint, Class<T> schemaClass) {\n\t\t\tif (!this.builders.containsKey(fingerprint)) {\n\t\t\t\tthis.builders.put(fingerprint, new io.intino.alexandria.led.UnsortedLedStreamBuilder(schemaClass, Schema.factoryOf(schemaClass), this.ledBufferSize, fileOf(fingerprint)));\n\t\t\t}\n\t\t\treturn (io.intino.alexandria.led.LedStream.Builder) this.builders.get(fingerprint);\n\t\t}\n\n\t\tprivate java.io.File fileOf(Fingerprint fingerprint) {\n\t\t\t return new java.io.File(root, fingerprint.name() + \".led.session\");\n\t\t}\n\n\t\tprivate static String cleanedNameOf(File file) {\n\t\t\treturn file.getName().substring(0, file.getName().indexOf(\"#\")).replace(\"-\", \"/\").replace(\".led.session\", \"\");\n\t\t}\n\n\t}\n}")}), this.rule().condition(this.trigger("put"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public void put")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String tank, Timetag timetag, java.util.function.Consumer<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> fact) {\n\tsession.put(tank, timetag, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class, fact);\n}")})});
    }
}

