/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.analytic.BuilderTemplate;
import io.intino.konos.builder.codegeneration.accessor.analytic.CubeWithSettersTemplate;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisTemplate;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisTemplate;
import io.intino.konos.builder.codegeneration.facts.FactRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Axis;
import io.intino.konos.model.graph.Cube;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.SizedData;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Predicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AnalyticBuilderRenderer
extends Renderer {
    private final KonosGraph graph;
    private final File destination;
    private final String packageName;
    private final FactRenderer factRenderer;

    public AnalyticBuilderRenderer(CompilationContext compilationContext, KonosGraph graph, File destination) {
        super(compilationContext, Target.Owner);
        this.graph = graph;
        this.destination = destination;
        this.destination.mkdirs();
        this.packageName = compilationContext.packageName();
        this.factRenderer = new FactRenderer();
    }

    @Override
    public void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph);
        this.renderBuilder(this.graph);
    }

    private void renderAxes(List<Axis> axes) {
        Commons.writeFrame(this.destinationDirectory(), "Axis", Formatters.customize(new CategoricalAxisTemplate()).render((Object)new FrameBuilder(new String[]{"interface"}).add("package", (Object)this.context.packageName()).toFrame()));
        for (Axis axis : axes) {
            if (axis.isCategorical()) {
                this.renderAxis(axis.asCategorical());
                continue;
            }
            this.renderAxis(axis.asContinuous());
        }
    }

    private void renderCubes(KonosGraph graph) {
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> Commons.writeFrame(new File(this.destinationDirectory(), "cubes"), cube.name$() + "Builder", this.cubeTemplate().render((Object)this.renderCube((Cube)((Object)cube)).toFrame())));
    }

    private FrameBuilder renderCube(Cube cube) {
        FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.packageName).add("name", (Object)cube.name$());
        this.factRenderer.render(cube, fb);
        return fb;
    }

    private void renderBuilder(KonosGraph graph) {
        FrameBuilder builder = new FrameBuilder(new String[]{"builder"}).add("package", (Object)this.packageName).add("name", (Object)(this.context.boxName() + "AnalyticBuilder"));
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> builder.add("cube", (Object)this.renderCube((Cube)((Object)cube))));
        Commons.writeFrame(this.destinationDirectory(), this.context.boxName() + "AnalyticBuilder", this.builderTemplate().render((Object)builder.toFrame()));
    }

    private void renderAxis(Axis.Categorical axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"axis"}).add("package", (Object)this.context.packageName()).add("name", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("label", (Object)axis.label());
        if (axis.asAxis().isDynamic()) {
            fb.add("dynamic", (Object)";");
        }
        if (axis.includeLabel() != null) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)"label").add("index", (Object)2));
        }
        int offset = this.offset(axis);
        if (axis.include() != null) {
            List<Axis> includes = axis.include().axes();
            for (int i = 0; i < includes.size(); ++i) {
                fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)includes.get(i).name$()).add("index", (Object)(i + offset)));
            }
        }
        Commons.writeFrame(new File(this.destinationDirectory(), "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()), Formatters.customize(new CategoricalAxisTemplate()).render((Object)fb.toFrame()));
    }

    private int offset(Axis.Categorical axis) {
        return axis.includeLabel() != null ? 3 : 2;
    }

    private void renderAxis(Axis.Continuous axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"continuous"}).add("package", (Object)this.context.packageName()).add("name", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("label", (Object)axis.label());
        fb.add("rangeSize", (Object)axis.rangeList().size());
        int index = 0;
        for (Axis.Continuous.Range range : axis.rangeList()) {
            FrameBuilder rangeFb = new FrameBuilder(new String[]{"range"}).add("index", (Object)index);
            if (range.isLowerBound()) {
                rangeFb.add("lower").add("bound", (Object)range.asLowerBound().lowerBound());
            } else if (range.isUpperBound()) {
                rangeFb.add("upper").add("bound", (Object)range.asUpperBound().upperBound());
            } else if (range.isBound()) {
                rangeFb.add("lower", (Object)range.asBound().lowerBound()).add("upper", (Object)range.asBound().upperBound());
            }
            fb.add("range", (Object)rangeFb);
            ++index;
        }
        Commons.writeFrame(new File(this.destinationDirectory(), "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()), Formatters.customize(new ContinuousAxisTemplate()).render((Object)fb.toFrame()));
    }

    private List<FrameBuilder> columns(Cube.Fact fact) {
        int offset = 0;
        ArrayList<FrameBuilder> list = new ArrayList<FrameBuilder>();
        ArrayList<Cube.Fact.Column> columns = new ArrayList<Cube.Fact.Column>(fact.columnList());
        columns.sort(Comparator.comparingInt(a -> a.asType().size()));
        Collections.reverse(columns);
        for (Cube.Fact.Column c : columns) {
            FrameBuilder b = this.process(c, offset);
            if (b == null) continue;
            offset += this.sizeOf(c).intValue();
            list.add(b.add("owner", (Object)fact.core$().owner().name()));
        }
        return list;
    }

    private FrameBuilder process(Cube.Fact.Column column, int offset) {
        if (column.isCategory()) {
            return this.processCategoryAttribute(column.asCategory(), column.name$(), offset);
        }
        return this.processAttribute(column, offset);
    }

    private FrameBuilder processAttribute(Cube.Fact.Column column, int offset) {
        SizedData.Type type = column.asType();
        FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("name", (Object)((Cube.Fact.Column)column.a$(Cube.Fact.Column.class)).name$()).add("offset", (Object)offset).add("type", (Object)(this.isPrimitive(type) ? type.primitive() : type.type()));
        column.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        if (this.isAligned(type, offset)) {
            builder.add("aligned", (Object)"Aligned");
        } else {
            builder.add("bits", (Object)type.size());
        }
        builder.add("size", (Object)type.size());
        return builder;
    }

    private boolean isAligned(SizedData.Type column, int offset) {
        return (offset == 0 || AnalyticBuilderRenderer.log2(offset) % 1.0 == 0.0) && column.maxSize() == column.size();
    }

    private boolean isPrimitive(SizedData.Type column) {
        SizedData data = column.asSizedData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isReal();
    }

    private FrameBuilder processCategoryAttribute(SizedData.Category column, String name, int offset) {
        return new FrameBuilder(new String[]{"column", "categorical"}).add("name", (Object)name).add("type", (Object)column.axis().name$()).add("offset", (Object)offset).add("bits", (Object)this.sizeOf((Cube.Fact.Column)column.a$(Cube.Fact.Column.class)));
    }

    public static double log2(int N) {
        return Math.log(N) / Math.log(2.0);
    }

    private Integer sizeOf(Cube.Fact.Column column) {
        return column.isCategory() ? this.sizeOf(column.asCategory().axis().asCategorical()).intValue() : column.asType().size();
    }

    private Integer sizeOf(Axis.Categorical axis) {
        try {
            return (int)Math.ceil(AnalyticBuilderRenderer.log2(this.countLines(axis) + 1));
        }
        catch (IOException e) {
            return 0;
        }
    }

    private int countLines(Axis.Categorical axis) throws IOException {
        return (int)new BufferedReader(new InputStreamReader(this.resource(axis))).lines().count();
    }

    private FileInputStream resource(Axis.Categorical axis) throws FileNotFoundException {
        return new FileInputStream(this.context.res(Target.Owner).getAbsolutePath() + "/analytic/axes/" + axis.name$() + ".tsv");
    }

    private File destinationDirectory() {
        return new File(this.destination, this.packageName.replace(".", "/") + "/analytic");
    }

    private Template builderTemplate() {
        return Formatters.customize(new BuilderTemplate());
    }

    private Template cubeTemplate() {
        return Formatters.customize(new CubeWithSettersTemplate());
    }
}

