/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisTemplate;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisTemplate;
import io.intino.konos.builder.codegeneration.analytic.CubeTemplate;
import io.intino.konos.builder.codegeneration.analytic.VirtualCubeTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Axis;
import io.intino.konos.model.graph.Cube;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.SizedData;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Predicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AnalyticRenderer
extends Renderer {
    private final File src;
    private final File gen;
    private final KonosGraph graph;

    public AnalyticRenderer(CompilationContext context, KonosGraph graph) {
        super(context, Target.Owner);
        this.src = new File(context.src(Target.Owner), "analytic");
        this.gen = new File(context.gen(Target.Owner), "analytic");
        this.graph = graph;
    }

    @Override
    protected void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph.cubeList());
    }

    private void renderAxes(List<Axis> axes) {
        if (axes.isEmpty()) {
            return;
        }
        Commons.writeFrame(this.gen, "Axis", Formatters.customize(new CategoricalAxisTemplate()).render((Object)new FrameBuilder(new String[]{"interface"}).add("package", (Object)this.context.packageName()).toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axes.get(0)), Commons.javaFile(this.gen, "Axis").getAbsolutePath()));
        for (Axis axis : axes) {
            if (axis.isCategorical()) {
                this.renderAxis(axis.asCategorical());
                continue;
            }
            this.renderAxis(axis.asContinuous());
        }
    }

    private void renderCubes(List<Cube> cubeList) {
        for (Cube cube : cubeList) {
            FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.context.packageName()).add("name", (Object)cube.name$());
            if (cube.isVirtual()) {
                this.renderVirtualCube(cube.asVirtual(), fb);
                continue;
            }
            this.renderCube(cube, fb);
        }
    }

    private void renderCube(Cube cube, FrameBuilder fb) {
        this.addDimensionsAndIndicators(cube, null, fb);
        fb.add("id", cube.fact().columnList().stream().filter(SizedData::isId).map(Layer::name$).findFirst().orElse(null));
        if (cube.splitted() != null) {
            this.addSplit(cube, fb);
        }
        fb.add("index", (Object)new FrameBuilder(new String[]{"index", cube.index() != null ? "normal" : "total"}).add("value", (Object)""));
        this.addFact(cube, fb);
        this.write(cube, fb);
    }

    private void renderVirtualCube(Cube.Virtual virtualCube, FrameBuilder fb) {
        for (Cube reference : new Cube[]{virtualCube.main(), virtualCube.join()}) {
            this.addDimensionsAndIndicators(reference, virtualCube.asCube(), fb);
            this.addFact(reference, fb);
        }
        fb.add("index", (Object)new FrameBuilder(new String[]{"index", virtualCube.index() != null ? "index" : "total"}).add("value", (Object)""));
        fb.add("mainCube", (Object)virtualCube.main().name$());
        fb.add("joinCube", (Object)virtualCube.join().name$());
        fb.add("cube", (Object)new String[]{virtualCube.main().name$(), virtualCube.join().name$()});
        if (virtualCube.main().splitted() != null) {
            this.addSplit(virtualCube.main(), fb);
        }
        this.write(virtualCube.asCube(), fb);
    }

    private void write(Cube cube, FrameBuilder fb) {
        Template template = Formatters.customize(this.template(cube));
        Commons.writeFrame(new File(this.gen, "cubes"), "Abstract" + Commons.firstUpperCase(cube.name$()), template.render((Object)fb.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(cube), Commons.javaFile(new File(this.gen, "cubes"), "Abstract" + Commons.firstUpperCase(cube.name$())).getAbsolutePath()));
        Commons.writeFrame(new File(this.src, "cubes"), cube.name$(), template.render((Object)fb.add("src").toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(cube), Commons.javaFile(new File(this.src, "cubes"), Commons.firstUpperCase(cube.name$())).getAbsolutePath()));
    }

    private void addFact(Cube cube, FrameBuilder fb) {
        int offset = 0;
        ArrayList<Cube.Fact.Column> columns = new ArrayList<Cube.Fact.Column>(cube.fact().columnList());
        columns.sort(Comparator.comparingInt(a -> a.asType().size()));
        Collections.reverse(columns);
        for (Cube.Fact.Column column : columns) {
            fb.add("column", (Object)this.columnFrame(column, offset, cube.name$()));
            offset += this.sizeOf(column).intValue();
        }
        fb.add("size", (Object)offset);
    }

    private void addSplit(Cube cube, FrameBuilder fb) {
        fb.add("split", (Object)new FrameBuilder(new String[]{"split"}).add("name", (Object)cube.splitted().name$()).add("value", (Object)cube.splitted().splits().toArray(new String[0])));
    }

    private Template template(Cube cube) {
        return cube.isVirtual() ? new VirtualCubeTemplate() : new CubeTemplate();
    }

    private void addDimensionsAndIndicators(Cube cube, Cube sourceCube, FrameBuilder fb) {
        cube.dimensionList().forEach(selector -> fb.add("dimension", (Object)this.dimensionFrame(cube, sourceCube, (Cube.Dimension)((Object)selector))));
        cube.indicatorList().forEach(indicator -> fb.add("indicator", (Object)this.inicatorFrame(cube, sourceCube, (Cube.Indicator)((Object)indicator))));
        for (Cube.CustomFilter customFilter : cube.customFilterList()) {
            fb.add("customFilter", (Object)new FrameBuilder(new String[]{"customFilter"}).add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)customFilter.name$()));
        }
    }

    private FrameBuilder dimensionFrame(Cube cube, Cube sourceCube, Cube.Dimension dimension) {
        FrameBuilder fb = new FrameBuilder(new String[]{"dimension", dimension.axis().core$().is(Axis.Categorical.class) ? "categorical" : "continuous"}).add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)dimension.name$()).add("source", (Object)dimension.attribute().name$()).add("axis", (Object)dimension.axis().name$());
        if (dimension.axis().i$(Axis.Categorical.class)) {
            fb.add("type", (Object)dimension.axis().name$());
        }
        return fb;
    }

    private FrameBuilder inicatorFrame(Cube cube, Cube sourceCube, Cube.Indicator indicator) {
        return new FrameBuilder(new String[]{"indicator"}).add(indicator.isAverage() ? "average" : "sum").add("cube", (Object)(sourceCube != null ? sourceCube.name$() : cube.name$())).add("name", (Object)indicator.name$()).add("label", (Object)indicator.label()).add("index", (Object)new FrameBuilder(new String[]{sourceCube == null && cube.index() != null || sourceCube != null && sourceCube.index() != null ? "index" : "total"})).add("source", (Object)indicator.source().name$()).add("unit", (Object)indicator.unit());
    }

    private FrameBuilder columnFrame(Cube.Fact.Column column, int offset, String cube) {
        if (column.isCategory()) {
            return this.processCategoryColumn(column.asCategory(), column.name$(), offset, cube);
        }
        return this.processColumn(column, offset, cube);
    }

    private FrameBuilder processColumn(Cube.Fact.Column column, int offset, String cube) {
        SizedData.Type asType = column.asType();
        FrameBuilder builder = new FrameBuilder(new String[]{"column", column.core$().is(Cube.Fact.Attribute.class) ? "attribute" : "measure"}).add("name", (Object)((Cube.Fact.Column)column.a$(Cube.Fact.Column.class)).name$()).add("offset", (Object)offset).add("cube", (Object)cube).add("type", (Object)this.type(asType));
        column.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        if (this.isAligned(asType, offset)) {
            builder.add("aligned", (Object)"Aligned");
        } else {
            builder.add("bits", (Object)asType.size());
        }
        builder.add("size", (Object)asType.size());
        return builder;
    }

    private FrameBuilder processCategoryColumn(SizedData.Category column, String name, int offset, String cube) {
        Axis.Categorical axis = column.axis().asCategorical();
        return new FrameBuilder(new String[]{"column", "categorical"}).add("name", (Object)name).add("type", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("offset", (Object)offset).add("cube", (Object)cube).add("bits", (Object)this.sizeOf(axis));
    }

    private String type(SizedData.Type type) {
        if (type.i$(SizedData.Category.class)) {
            return type.name$();
        }
        return this.isPrimitive(type) ? type.primitive() : type.type();
    }

    private Integer sizeOf(Cube.Fact.Column column) {
        return column.isCategory() ? this.sizeOf(column.asCategory().axis().asCategorical()).intValue() : column.asType().size();
    }

    private Integer sizeOf(Axis.Categorical axis) {
        try {
            return (int)Math.ceil(AnalyticRenderer.log2(this.countLines(axis) + 1));
        }
        catch (IOException e) {
            return 0;
        }
    }

    private int countLines(Axis.Categorical axis) throws IOException {
        return (int)new BufferedReader(new InputStreamReader(this.resource(axis))).lines().count();
    }

    private FileInputStream resource(Axis.Categorical axis) throws FileNotFoundException {
        return new FileInputStream(this.context.res(Target.Owner).getAbsolutePath() + "/analytic/axes/" + Formatters.camelCaseToSnakeCase().format((Object)axis.name$()).toString() + ".tsv");
    }

    private boolean isAligned(SizedData.Type attribute, int offset) {
        return (offset == 0 || AnalyticRenderer.log2(offset) % 1.0 == 0.0) && attribute.maxSize() == attribute.size();
    }

    private boolean isPrimitive(SizedData.Type attribute) {
        SizedData data = attribute.asSizedData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isId() || data.isReal();
    }

    public static double log2(int N) {
        return Math.log(N) / Math.log(2.0);
    }

    private void renderAxis(Axis.Categorical axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"axis"}).add("package", (Object)this.context.packageName()).add("name", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("label", (Object)axis.label());
        if (axis.asAxis().isDynamic()) {
            fb.add("dynamic", (Object)";");
        }
        if (axis.includeLabel() != null) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)"label").add("index", (Object)2));
        }
        int offset = this.offset(axis);
        if (axis.include() != null) {
            List<Axis> includes = axis.include().axes();
            for (int i = 0; i < includes.size(); ++i) {
                fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)includes.get(i).name$()).add("index", (Object)(i + offset)));
            }
        }
        Commons.writeFrame(new File(this.gen, "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()), Formatters.customize(new CategoricalAxisTemplate()).render((Object)fb.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axis), Commons.javaFile(new File(this.gen, "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString())).getAbsolutePath()));
    }

    private int offset(Axis.Categorical axis) {
        return axis.includeLabel() != null ? 3 : 2;
    }

    private void renderAxis(Axis.Continuous axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"continuous"}).add("package", (Object)this.context.packageName()).add("name", (Object)Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()).add("label", (Object)axis.label());
        fb.add("rangeSize", (Object)axis.rangeList().size());
        int index = 0;
        for (Axis.Continuous.Range range : axis.rangeList()) {
            FrameBuilder rangeFb = new FrameBuilder(new String[]{"range"}).add("index", (Object)index);
            if (range.isLowerBound()) {
                rangeFb.add("lower").add("bound", (Object)range.asLowerBound().lowerBound());
            } else if (range.isUpperBound()) {
                rangeFb.add("upper").add("bound", (Object)range.asUpperBound().upperBound());
            } else if (range.isBound()) {
                rangeFb.add("lower", (Object)range.asBound().lowerBound()).add("upper", (Object)range.asBound().upperBound());
            }
            fb.add("range", (Object)rangeFb);
            ++index;
        }
        Commons.writeFrame(new File(this.gen, "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString()), Formatters.customize(new ContinuousAxisTemplate()).render((Object)fb.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axis), Commons.javaFile(new File(this.gen, "axes"), Commons.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)axis.name$()).toString())).getAbsolutePath()));
    }
}

