/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRendererFactory;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Labeled;
import io.intino.konos.model.graph.Multiple;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Template;
import io.intino.magritte.framework.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComponentRenderer<C extends Component>
extends DisplayRenderer<C> {
    private boolean buildChildren = false;
    private boolean decorated;
    private Display owner;
    private static final ComponentRendererFactory factory = new ComponentRendererFactory();
    private static final Map<String, FrameBuilder> componentFrameMap = new HashMap<String, FrameBuilder>();

    public ComponentRenderer(CompilationContext compilationContext, C component, TemplateProvider provider, Target target) {
        super(compilationContext, component, provider, target);
        this.decorated = ElementHelper.isRoot(component);
    }

    @Override
    public final FrameBuilder buildFrame() {
        String frameId = this.frameId();
        if (componentFrameMap.containsKey(frameId)) {
            return componentFrameMap.get(frameId);
        }
        FrameBuilder builder = super.buildFrame().add("component");
        if (!this.belongsToAccessible((Display)this.element)) {
            builder.add("concreteBox", (Object)this.boxName());
        }
        this.addOwner(builder);
        this.addProperties(builder);
        if (this.buildChildren) {
            builder.add("child");
        }
        builder.add("methodName", (Object)(((Component)this.element).i$(Block.Conditional.class) && !((Component)this.element).i$(Block.Multiple.class) ? "initConditional" : "init"));
        this.addSpecificTypes(builder);
        this.addComponents((Component)this.element, builder);
        this.addReferences((Component)this.element, builder);
        this.addFacets((PassiveView)this.element, builder);
        this.addExtends((Component)this.element, builder);
        this.addImplements((Component)this.element, builder);
        this.fill(builder);
        componentFrameMap.put(frameId, builder);
        return builder;
    }

    public static void clearCache() {
        componentFrameMap.clear();
    }

    public void buildChildren(boolean value) {
        this.buildChildren = value;
    }

    public void decorated(boolean value) {
        this.decorated = value;
    }

    public Display owner() {
        return this.owner;
    }

    public void owner(Display owner) {
        this.owner = owner;
    }

    protected FrameBuilder addOwner(FrameBuilder builder) {
        if (this.owner != null) {
            builder.add("owner", (Object)((ElementHelper.isRoot(this.owner) ? "Abstract" : "") + Formatters.firstUpperCase(this.owner.name$())));
        }
        Component parentComponent = (Component)((Component)this.element).core$().ownerAs(Component.class);
        if (((Component)this.element).i$(OtherComponents.Stamp.class) && parentComponent != null && !ElementHelper.isRoot(parentComponent)) {
            builder.add("parentId", (Object)this.shortId(parentComponent));
        }
        return builder;
    }

    @Override
    protected void addDecoratedFrames(FrameBuilder builder) {
        this.addDecoratedFrames(builder, this.decorated);
    }

    protected void fill(FrameBuilder builder) {
    }

    private void addComponents(Component component, FrameBuilder builder) {
        this.addComponentsImports(builder);
        this.components(component).forEach(c -> {
            FrameBuilder componentBuilder = this.buildChildren ? this.childFrame((Component)((Object)c)) : this.componentFrame((Component)((Object)c));
            builder.add("component", (Object)componentBuilder);
        });
    }

    private void addReferences(Component component, FrameBuilder builder) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>(this.references(component));
        builder.add("componentReferences", (Object)this.componentReferencesFrame());
        components.forEach(c -> builder.add("reference", (Object)this.referenceFrame((Component)((Object)c))));
    }

    private FrameBuilder referenceFrame(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, component, this.templateProvider, this.target);
        FrameBuilder builder = new FrameBuilder(new String[]{"reference"}).add(this.typeOf(component)).add("name", (Object)component.name$());
        Component parentComponent = (Component)component.core$().ownerAs(Component.class);
        builder.add("box", (Object)this.boxName());
        if (!this.belongsToAccessible(component)) {
            builder.add("concreteBox", (Object)this.boxName());
        }
        builder.add("id", (Object)this.shortId(component));
        if (parentComponent != null) {
            builder.add("parentId", (Object)this.nameOf(parentComponent));
        }
        builder.add("properties", (Object)renderer.properties());
        this.addOwner(builder);
        this.addExtends(component, builder);
        return builder;
    }

    @Override
    protected FrameBuilder componentFrame(Component component) {
        return this.componentRenderer(component).buildFrame();
    }

    protected FrameBuilder childFrame(Component component) {
        FrameBuilder result = this.componentRenderer(component).buildFrame();
        String[] ancestors = this.ancestors(component);
        Component parent = (Component)component.core$().ownerAs(Component.class);
        if (parent != null) {
            result.add("parent", (Object)this.nameOf(parent));
        }
        result.add("ancestors", (Object)ancestors);
        result.add("ancestorsNotMe", (Object)Arrays.copyOfRange(ancestors, 1, ancestors.length));
        result.add("value", (Object)this.componentRenderer(component).buildFrame().add("addType", (Object)this.typeOf(component)));
        return result;
    }

    public FrameBuilder properties() {
        FrameBuilder result = new FrameBuilder().add("properties").add(this.typeOf(this.element));
        if (((Component)this.element).color() != null && !((Component)this.element).color().isEmpty()) {
            result.add("color", (Object)((Component)this.element).color());
        }
        if (((Component)this.element).isOption()) {
            result.add("name", (Object)((Component)this.element).asOption().name$());
        }
        if (((Component)this.element).i$(Labeled.class)) {
            result.add("label", (Object)((Labeled)((Component)this.element).a$(Labeled.class)).label());
        }
        if (!((Component)this.element).visible()) {
            result.add("visible", (Object)((Component)this.element).visible());
        }
        if (((Component)this.element).i$(Multiple.class)) {
            Multiple abstractMultiple = (Multiple)((Component)this.element).a$(Multiple.class);
            result.add("instances", (Object)this.nameOf(this.element));
            result.add("multipleArrangement", (Object)abstractMultiple.arrangement().name());
            result.add("multipleSpacing", (Object)abstractMultiple.spacing().value());
            result.add("multipleNoItemsMessage", (Object)(abstractMultiple.noItemsMessage() != null ? abstractMultiple.noItemsMessage() : ""));
        }
        if (((Component)this.element).format() != null) {
            String[] format = (String[])((Component)this.element).format().stream().map(Layer::name$).toArray(String[]::new);
            result.add("format", (Object)format);
        }
        return result;
    }

    protected String className(Class clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    private String[] ancestors(Component component) {
        ArrayList<String> result = new ArrayList<String>();
        Component parent = (Component)component.core$().ownerAs(Component.class);
        while (parent != null) {
            result.add(0, this.nameOf(parent));
            if (parent.i$(CatalogComponents.Collection.Mold.Item.class)) break;
            parent = (Component)parent.core$().ownerAs(Component.class);
        }
        return result.toArray(new String[0]);
    }

    private UIRenderer componentRenderer(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, component, this.templateProvider, this.target);
        renderer.buildChildren(true);
        renderer.decorated(this.decorated);
        renderer.owner(this.owner);
        return renderer;
    }

    private List<Component> references(Component component) {
        if (((Component)this.element).i$(HelperComponents.Row.class)) {
            return ((HelperComponents.Row)((Component)this.element).a$(HelperComponents.Row.class)).items().stream().map(i -> (Component)i.a$(Component.class)).collect(Collectors.toList());
        }
        return component.components();
    }

    private void addExtends(Component element, FrameBuilder builder) {
        builder.add("extends", (Object)this.extendsFrame(element, builder));
    }

    protected FrameBuilder extendsFrame(Component element, FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder(new String[]{"extends"});
        if (element.i$(CatalogComponents.Collection.class)) {
            result.add("collection");
        }
        if (element.i$(CatalogComponents.Table.class)) {
            result.add("table");
        }
        result.add("name", (Object)this.nameOf(element));
        if (!this.addSpecificTypes(result)) {
            result.add("type", (Object)this.type());
        }
        this.addFacets(element, result);
        this.addDecoratedFrames(result, this.decorated);
        return result;
    }

    protected boolean addSpecificTypes(FrameBuilder builder) {
        if (((Component)this.element).i$(Multiple.class)) {
            String message = ((Multiple)((Component)this.element).a$(Multiple.class)).noItemsMessage();
            if (message != null) {
                builder.add("noItemsMessage", (Object)message);
            }
            FrameBuilder methodsFrame = this.addOwner(this.buildBaseFrame()).add("method").add("multiple");
            methodsFrame.add("componentType", (Object)this.multipleComponentType((Component)this.element));
            String objectType = this.multipleObjectType((Component)this.element);
            if (objectType != null) {
                methodsFrame.add("objectType", (Object)objectType);
                if (!objectType.equals("java.lang.Void")) {
                    methodsFrame.add("objectTypeValue", (Object)"value");
                }
            }
            methodsFrame.add("name", (Object)this.nameOf(this.element));
            builder.add("methods", (Object)methodsFrame);
            builder.add("multiple");
            builder.add("componentType", (Object)this.multipleComponentType((Component)this.element));
            if (objectType != null) {
                builder.add("objectType", (Object)objectType);
            }
        }
        if (((Component)this.element).i$(Template.class)) {
            builder.add("template");
            String modelClass = ((Template)((Component)this.element).a$(Template.class)).modelClass();
            builder.add("componentType", (Object)this.nameOf(this.element));
            builder.add("objectType", (Object)(modelClass != null ? modelClass : "java.lang.Void"));
            return true;
        }
        if (((Component)this.element).i$(OtherComponents.Stamp.class)) {
            builder.add("stamp");
            if (!((Component)this.element).i$(Multiple.class)) {
                builder.add("single");
            }
            Template template = ((OtherComponents.Stamp)((Component)this.element).a$(OtherComponents.Stamp.class)).template();
            builder.add("template", (Object)template.name$());
            builder.add("type", (Object)template.name$());
            builder.add("generic", (Object)(KonosGraph.isParent(this.context.graphName(), template) ? "<>" : ""));
            return true;
        }
        if (((Component)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            builder.add("item");
            CatalogComponents.Collection collection = (CatalogComponents.Collection)((CatalogComponents.Collection.Mold.Item)((Component)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).core$().ownerAs(CatalogComponents.Collection.class);
            builder.add("itemClass", (Object)(collection.itemClass() != null ? collection.itemClass() : "java.lang.Void"));
            return true;
        }
        return false;
    }

    private void addProperties(FrameBuilder builder) {
        FrameBuilder properties = this.properties();
        if (properties.slots() <= 0) {
            return;
        }
        builder.add("properties", (Object)this.properties());
    }

    private String multipleComponentType(C element) {
        String prefix = "io.intino.alexandria.ui.displays.components.";
        if (element.i$(DataComponents.Text.Multiple.class)) {
            return prefix + "Text";
        }
        if (element.i$(DataComponents.File.Multiple.class)) {
            return prefix + "File";
        }
        if (element.i$(DataComponents.Image.Multiple.class)) {
            return prefix + "Image";
        }
        if (element.i$(OtherComponents.BaseIcon.Multiple.class)) {
            return prefix + "Icon";
        }
        if (element.i$(DataComponents.Number.Multiple.class)) {
            return prefix + "Number";
        }
        if (element.i$(DataComponents.Date.Multiple.class)) {
            return prefix + "Date";
        }
        if (element.i$(OtherComponents.Stamp.Multiple.class)) {
            return Formatters.firstUpperCase(((OtherComponents.Stamp.Multiple)element.a$(OtherComponents.Stamp.Multiple.class)).template().name$());
        }
        if (element.i$(Block.Multiple.class)) {
            return Formatters.firstUpperCase(this.nameOf((Layer)element));
        }
        return null;
    }

    private String multipleObjectType(C element) {
        if (element.i$(DataComponents.Text.Multiple.class)) {
            return "java.lang.String";
        }
        if (element.i$(DataComponents.File.Multiple.class)) {
            return "java.net.URL";
        }
        if (element.i$(DataComponents.Image.Multiple.class)) {
            return "java.net.URL";
        }
        if (element.i$(OtherComponents.BaseIcon.Multiple.class)) {
            return "java.net.URL";
        }
        if (element.i$(DataComponents.Number.Multiple.class)) {
            return "java.lang.Double";
        }
        if (element.i$(DataComponents.Date.Multiple.class)) {
            return "java.time.Instant";
        }
        if (element.i$(OtherComponents.Stamp.Multiple.class)) {
            String modelClass = ((OtherComponents.Stamp.Multiple)element.a$(OtherComponents.Stamp.Multiple.class)).template().modelClass();
            return modelClass != null ? modelClass : "java.lang.Void";
        }
        if (element.i$(Block.Multiple.class)) {
            return "java.lang.Void";
        }
        return null;
    }

    protected FrameBuilder resourceMethodFrame(String method, String value) {
        FrameBuilder result = new FrameBuilder(new String[]{"resourceMethod"}).add("name", (Object)method).add("value", (Object)this.fixResourceValue(value));
        this.addOwner(result);
        return result;
    }

    protected FrameBuilder parameterMethodFrame(String name, String value) {
        FrameBuilder frame = new FrameBuilder(new String[]{"parameter"});
        frame.add("name", (Object)name);
        frame.add("value", (Object)value);
        this.addOwner(frame);
        return frame;
    }

    protected String fixResourceValue(String value) {
        return value.startsWith("/") ? value : "/" + value;
    }

    private void addImplements(C element, FrameBuilder builder) {
        if (!((Component)((Object)element)).isOption()) {
            return;
        }
        builder.add("implements", (Object)new FrameBuilder(new String[]{"implements", "option"}).add("option", (Object)""));
    }

    private FrameBuilder componentReferencesFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"componentReferences"});
        List<Component> componentList = null;
        if (((Component)this.element).i$(Block.class)) {
            componentList = ((Block)((Component)this.element).a$(Block.class)).componentList();
        } else if (((Component)this.element).i$(Template.class)) {
            componentList = ((Template)((Component)this.element).a$(Template.class)).componentList();
        } else if (((Component)this.element).i$(OtherComponents.Dialog.class)) {
            componentList = ((OtherComponents.Dialog)((Component)this.element).a$(OtherComponents.Dialog.class)).componentList();
        } else if (((Component)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            componentList = ((CatalogComponents.Collection.Mold.Item)((Component)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).componentList();
        }
        if (componentList == null) {
            return result;
        }
        result.add("forRoot");
        componentList.forEach(c -> this.addComponent((Component)((Object)c), result));
        return componentList.size() > 0 ? result : null;
    }

    private String frameId() {
        return this.nameOf(this.element) + (this.owner != null ? this.owner.name$() : "") + this.target.name() + this.buildChildren + this.decorated;
    }
}

