/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ServiceTemplate;
import io.intino.konos.builder.codegeneration.ui.I18nRenderer;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.RouteDispatcherRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Service;
import java.util.List;
import java.util.Set;

public class ServiceRenderer
extends UIRenderer {
    private final Service.UI service;

    public ServiceRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext, Target.Owner);
        this.service = service;
    }

    @Override
    public void render() {
        this.createUi();
        new I18nRenderer(this.context, this.service, this.target).execute();
        new RouteDispatcherRenderer(this.context, this.service, this.target).execute();
    }

    private void createUi() {
        List<Display> displays = this.service.graph().rootDisplays(this.context.graphName());
        FrameBuilder builder = this.buildFrame().add("ui").add("name", (Object)this.service.name$()).add("resource", (Object)this.resourcesFrame(this.service.resourceList()));
        if (this.userHome(this.service) != null) {
            builder.add("userHome", (Object)this.userHome(this.service).name$());
        }
        if (!displays.isEmpty()) {
            builder.add("display", (Object)this.displaysFrame(displays)).add("displaysImport", (Object)this.packageName());
        }
        if (this.service.authentication() != null) {
            builder.add("auth", (Object)this.service.authentication().by());
        }
        Commons.writeFrame(CodeGenerationHelper.serviceFolder(this.gen()), CodeGenerationHelper.serviceFilename(this.service.name$()), this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.service), Commons.javaFile(CodeGenerationHelper.serviceFolder(this.gen()), CodeGenerationHelper.serviceFilename(this.service.name$())).getAbsolutePath()));
    }

    private Frame[] resourcesFrame(List<Service.UI.Resource> resourceList) {
        return (Frame[])resourceList.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] displaysFrame(List<Display> displays) {
        return (Frame[])displays.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    public Service.UI.Resource userHome(Service.UI service) {
        return service.homeList().stream().filter(Service.UI.Resource::isConfidential).findFirst().orElse(null);
    }

    private Frame frameOf(Service.UI.Resource resource) {
        FrameBuilder result = new FrameBuilder(new String[]{"resource"}).add("abstractResource");
        result.add("name", (Object)resource.name$());
        Service.UI service = (Service.UI)resource.core$().ownerAs(Service.UI.class);
        String path = resource.path();
        Set<String> custom = Commons.extractParameters(path);
        FrameBuilder pathBuilder = new FrameBuilder(new String[]{"path"}).add("value", (Object)path).add("name", (Object)resource.name$());
        if (this.userHome(service) != null) {
            pathBuilder.add("userHome", (Object)this.userHome(service).name$());
        }
        if (!custom.isEmpty()) {
            pathBuilder.add("custom", (Object)custom.toArray(new String[0]));
        }
        result.add("path", (Object)pathBuilder);
        return result.toFrame();
    }

    private Frame frameOf(Display display) {
        FrameBuilder result = this.newDisplayFrame(display, new FrameBuilder(new String[]{"display"}));
        if (display.isAccessible()) {
            result.add("accessible").add("display", (Object)this.newDisplayFrame(display, new FrameBuilder(new String[]{"display"}).add("proxy")));
        }
        return result.toFrame();
    }

    private FrameBuilder newDisplayFrame(Display display, FrameBuilder builder) {
        String type = this.typeOf(display);
        if (!type.equalsIgnoreCase("display")) {
            builder.add("type", (Object)this.typeOf(display).toLowerCase());
        }
        builder.add("name", (Object)this.nameOf(display)).add("package", (Object)this.packageName());
        if (display.requestList().stream().anyMatch(r -> r.responseType().equals((Object)PassiveView.Request.ResponseType.Asset))) {
            builder.add("asset", (Object)display.name$());
        }
        return builder;
    }

    private Template template() {
        return this.addFormats(new ServiceTemplate());
    }
}

