/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Theme
extends Layer
implements Terminal {
    protected Type type;
    protected int contrastThreshold;
    protected double tonalOffset;
    protected List<Property> propertyList = new ArrayList<Property>();
    protected Primary primary;
    protected Secondary secondary;
    protected Error error;
    protected Typography typography;

    public Theme(Node node) {
        super(node);
    }

    public Type type() {
        return this.type;
    }

    public int contrastThreshold() {
        return this.contrastThreshold;
    }

    public double tonalOffset() {
        return this.tonalOffset;
    }

    public Theme type(Type value) {
        this.type = value;
        return this;
    }

    public Theme contrastThreshold(int value) {
        this.contrastThreshold = value;
        return this;
    }

    public Theme tonalOffset(double value) {
        this.tonalOffset = value;
        return this;
    }

    public List<Property> propertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    public Property property(int index) {
        return this.propertyList.get(index);
    }

    public List<Property> propertyList(Predicate<Property> predicate) {
        return this.propertyList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Primary primary() {
        return this.primary;
    }

    public Secondary secondary() {
        return this.secondary;
    }

    public Error error() {
        return this.error;
    }

    public Typography typography() {
        return this.typography;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Property>(this.propertyList).forEach(c -> components.add(c.core$()));
        if (this.primary != null) {
            components.add(this.primary.core$());
        }
        if (this.secondary != null) {
            components.add(this.secondary.core$());
        }
        if (this.error != null) {
            components.add(this.error.core$());
        }
        if (this.typography != null) {
            components.add(this.typography.core$());
        }
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
        map.put("contrastThreshold", new ArrayList<Integer>(Collections.singletonList(this.contrastThreshold)));
        map.put("tonalOffset", new ArrayList<Double>(Collections.singletonList(this.tonalOffset)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Theme$Property")) {
            this.propertyList.add((Property)node.as(Property.class));
        }
        if (node.is("Theme$Primary")) {
            this.primary = (Primary)node.as(Primary.class);
        }
        if (node.is("Theme$Secondary")) {
            this.secondary = (Secondary)node.as(Secondary.class);
        }
        if (node.is("Theme$Error")) {
            this.error = (Error)node.as(Error.class);
        }
        if (node.is("Theme$Typography")) {
            this.typography = (Typography)node.as(Typography.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Theme$Property")) {
            this.propertyList.remove(node.as(Property.class));
        }
        if (node.is("Theme$Primary")) {
            this.primary = null;
        }
        if (node.is("Theme$Secondary")) {
            this.secondary = null;
        }
        if (node.is("Theme$Error")) {
            this.error = null;
        }
        if (node.is("Theme$Typography")) {
            this.typography = null;
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("contrastThreshold")) {
            this.contrastThreshold = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("tonalOffset")) {
            this.tonalOffset = (Double)DoubleLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("contrastThreshold")) {
            this.contrastThreshold = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("tonalOffset")) {
            this.tonalOffset = (Double)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Typography
    extends Layer
    implements Terminal {
        protected int fontSize;
        protected List<String> fontFamily = new ArrayList<String>();

        public Typography(Node node) {
            super(node);
        }

        public int fontSize() {
            return this.fontSize;
        }

        public List<String> fontFamily() {
            return this.fontFamily;
        }

        public String fontFamily(int index) {
            return this.fontFamily.get(index);
        }

        public List<String> fontFamily(Predicate<String> predicate) {
            return this.fontFamily().stream().filter(predicate).collect(Collectors.toList());
        }

        public Typography fontSize(int value) {
            this.fontSize = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("fontSize", new ArrayList<Integer>(Collections.singletonList(this.fontSize)));
            map.put("fontFamily", this.fontFamily);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("fontSize")) {
                this.fontSize = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("fontFamily")) {
                this.fontFamily = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("fontSize")) {
                this.fontSize = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("fontFamily")) {
                this.fontFamily = new ArrayList(values);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Error
    extends Property
    implements Terminal {
        public Error(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Secondary
    extends Property
    implements Terminal {
        public Secondary(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Primary
    extends Property
    implements Terminal {
        public Primary(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class Property
    extends Layer
    implements Terminal {
        protected String color;

        public Property(Node node) {
            super(node);
        }

        public String color() {
            return this.color;
        }

        public Property color(String value) {
            this.color = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("color", new ArrayList<String>(Collections.singletonList(this.color)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("color")) {
                this.color = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("color")) {
                this.color = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Primary primary(String color) {
            Primary newElement = (Primary)Theme.this.core$().graph().concept(Primary.class).createNode(this.name, Theme.this.core$()).as(Primary.class);
            newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
            return newElement;
        }

        public Secondary secondary(String color) {
            Secondary newElement = (Secondary)Theme.this.core$().graph().concept(Secondary.class).createNode(this.name, Theme.this.core$()).as(Secondary.class);
            newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
            return newElement;
        }

        public Error error(String color) {
            Error newElement = (Error)Theme.this.core$().graph().concept(Error.class).createNode(this.name, Theme.this.core$()).as(Error.class);
            newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
            return newElement;
        }

        public Typography typography() {
            Typography newElement = (Typography)Theme.this.core$().graph().concept(Typography.class).createNode(this.name, Theme.this.core$()).as(Typography.class);
            return newElement;
        }
    }

    public static enum Type {
        Normal,
        Dark;

    }
}

