/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.AbstractGraph;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import io.intino.magritte.framework.Graph;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KonosGraph
extends AbstractGraph {
    private static Map<String, Set<String>> hierarchyDisplays = new HashMap<String, Set<String>>();
    private static Map<String, List<CatalogComponents.Collection.Mold.Item>> items = new HashMap<String, List<CatalogComponents.Collection.Mold.Item>>();
    private static Map<String, List<HelperComponents.Row>> rows = new HashMap<String, List<HelperComponents.Row>>();
    private static Map<String, List<CatalogComponents.Table>> tables = new HashMap<String, List<CatalogComponents.Table>>();

    public KonosGraph(Graph graph) {
        super(graph);
    }

    public KonosGraph(Graph graph, KonosGraph wrapper) {
        super(graph, wrapper);
    }

    public KonosGraph init(String group) {
        this.resetCache();
        this.createPrivateComponents(group);
        return this;
    }

    private void resetCache() {
        tables = new HashMap<String, List<CatalogComponents.Table>>();
        items = new HashMap<String, List<CatalogComponents.Collection.Mold.Item>>();
        rows = new HashMap<String, List<HelperComponents.Row>>();
    }

    public List<Display> rootDisplays(String group) {
        KonosGraph graph = this;
        List<Display> rootDisplays = graph.displayList().stream().filter(d -> d.core$().ownerAs(PassiveView.class) == null).collect(Collectors.toList());
        rootDisplays.addAll(this.itemsDisplays(group));
        rootDisplays.addAll(this.rowsDisplays(group));
        return rootDisplays;
    }

    public List<CatalogComponents.Collection.Mold.Item> itemsDisplays(String group) {
        if (!items.containsKey(group)) {
            items.put(group, this.core$().find(CatalogComponents.Collection.Mold.Item.class));
        }
        return items.get(group);
    }

    public List<HelperComponents.Row> rowsDisplays(String group) {
        if (!rows.containsKey(group)) {
            rows.put(group, this.core$().find(HelperComponents.Row.class));
        }
        return rows.get(group);
    }

    public static List<CatalogComponents.Table> tablesDisplays(KonosGraph graph, String group) {
        if (!tables.containsKey(group)) {
            tables.put(group, graph.core$().find(CatalogComponents.Table.class));
        }
        return tables.get(group);
    }

    public static Template templateFor(Service.UI.Resource resource) {
        return resource.asPage().template();
    }

    public static boolean isParent(String group, PassiveView passiveView) {
        KonosGraph.loadParents(group, passiveView.graph());
        return hierarchyDisplays.get(group).contains(passiveView.name$());
    }

    public Set<String> findCustomParameters(Service.Messaging service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.Messaging.Request request : service.requestList()) {
            set.addAll(KonosGraph.extractParameters(request.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Service.REST service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.REST.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Service.UI service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(KonosGraph.extractParameters(service.authentication().by()));
        }
        for (Service.UI.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    private static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    private static void loadParents(String group, KonosGraph graph) {
        if (hierarchyDisplays.containsKey(group)) {
            return;
        }
        hierarchyDisplays.put(group, graph.core$().find(PassiveView.ExtensionOf.class).stream().map(d -> ((PassiveView.ExtensionOf)d.core$().as(PassiveView.ExtensionOf.class)).parentView().name$()).collect(Collectors.toSet()));
    }

    private void createPrivateComponents(String group) {
        KonosGraph.tablesDisplays(this, group).forEach(this::createUiTableRow);
    }

    private void createUiTableRow(CatalogComponents.Table element) {
        List<CatalogComponents.Collection.Mold.Item> itemList = element.moldList().stream().map(CatalogComponents.Collection.Mold::item).collect(Collectors.toList());
        String name = KonosGraph.firstUpperCase(element.name$()) + "Row";
        HelperComponents privateComponents = this.helperComponentsList().size() <= 0 ? this.create(element.core$().stash()).helperComponents() : this.helperComponents(0);
        HelperComponents.Row row = privateComponents.rowList().stream().filter(c -> c.name$().equals(name)).findFirst().orElse(null);
        if (row == null) {
            privateComponents.create(name).row(itemList);
        }
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public List<Service.Messaging> messagingServiceList() {
        return this.serviceList(Service::isMessaging).map(Service::asMessaging).collect(Collectors.toList());
    }

    public List<Service.REST> restServiceList() {
        return this.serviceList(Service::isREST).map(Service::asREST).collect(Collectors.toList());
    }

    public List<Service.UI> uiServiceList() {
        return this.serviceList(Service::isUI).map(Service::asUI).collect(Collectors.toList());
    }

    public List<Service.JMX> jmxServiceList() {
        return this.serviceList(Service::isJMX).map(Service::asJMX).collect(Collectors.toList());
    }

    public List<Service.SlackBot> slackBotServiceList() {
        return this.serviceList(Service::isSlackBot).map(Service::asSlackBot).collect(Collectors.toList());
    }
}

