/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.bpm;

import io.intino.alexandria.logger.Logger;
import io.intino.bpmparser.BpmnParser;
import io.intino.bpmparser.Link;
import io.intino.bpmparser.State;
import io.intino.bpmparser.Task;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.bpm.ProcessTemplate;
import io.intino.konos.builder.codegeneration.bpm.WorkflowTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Workflow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BpmRenderer
extends Renderer {
    private final CompilationContext compilationContext;
    private final List<Workflow.Process> processes;
    private final File src;
    private final File gen;
    private final KonosGraph graph;
    private List<String> stateServices = new ArrayList<String>();

    public BpmRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.compilationContext = compilationContext;
        this.processes = graph.workflow() != null ? graph.workflow().processList() : Collections.emptyList();
        this.src = new File(compilationContext.src(Target.Owner), "bpm");
        this.gen = new File(compilationContext.gen(Target.Owner), "bpm");
        this.graph = graph;
    }

    @Override
    protected void render() {
        this.renderProcesses();
        this.renderWorkflow();
    }

    private void renderWorkflow() {
        if (this.processes.isEmpty()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"workflow"}).add("box", (Object)this.compilationContext.boxName()).add("package", (Object)this.compilationContext.packageName()).add("terminal", (Object)this.compilationContext.dataHubManifest().qn).add(this.compilationContext.boxName()).add("process", this.processes.stream().map(this::frameOf).toArray(Frame[]::new));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.graph.workflow()), Commons.javaFile(this.gen, "Workflow").getAbsolutePath()));
        Commons.writeFrame(this.gen, "Workflow", Formatters.customize(new WorkflowTemplate()).render((Object)builder.toFrame()));
    }

    private Frame frameOf(Workflow.Process p) {
        return new FrameBuilder(new String[]{"process"}).add("name", (Object)p.name$()).toFrame();
    }

    private void renderProcesses() {
        for (Workflow.Process process : this.processes) {
            this.stateServices.clear();
            File file = process.bpmn() == null ? null : new File(process.bpmn().getFile());
            if (file == null || !file.exists()) continue;
            this.renderProcess(process, file);
        }
    }

    private void renderProcess(Workflow.Process process, File file) {
        FrameBuilder builder = new FrameBuilder(new String[]{"process"}).add("box", (Object)this.compilationContext.boxName()).add("package", (Object)this.compilationContext.packageName()).add("name", (Object)process.name$());
        try {
            BpmnParser bpmnParser = new BpmnParser((InputStream)new FileInputStream(file));
            State initial = ((Link)bpmnParser.getNodeWalker().getInitial().links().get(0)).state().type(State.Type.Initial);
            this.walk(builder, process, initial);
            for (String stateService : this.stateServices) {
                builder.add("accessor", (Object)new FrameBuilder(new String[]{"accessor"}).add("name", (Object)stateService));
            }
            this.compilationContext.classes().put(((Object)((Object)process)).getClass().getSimpleName() + "#" + process.name$(), "bpm." + process.name$());
            Commons.writeFrame(this.gen, "Abstract" + Commons.firstUpperCase(process.name$()), Formatters.customize(new ProcessTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(process), Commons.javaFile(this.gen, "Abstract" + Commons.firstUpperCase(process.name$())).getAbsolutePath()));
            if (!this.alreadyRendered(this.src, process.name$())) {
                Commons.writeFrame(this.src, process.name$(), Formatters.customize(new ProcessTemplate()).render((Object)builder.add("src").toFrame()));
            }
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
        }
    }

    private void walk(FrameBuilder builder, Workflow.Process process, State initial) {
        LinkedHashMap<String, FrameBuilder> states = new LinkedHashMap<String, FrameBuilder>();
        LinkedHashMap<String, FrameBuilder> links = new LinkedHashMap<String, FrameBuilder>();
        this.framesFrom(initial, process, states, links);
        builder.add("state", (Object)states.values().toArray(new FrameBuilder[0])).add("link", (Object)links.values().toArray(new FrameBuilder[0]));
    }

    private void framesFrom(State state, Workflow.Process process, Map<String, FrameBuilder> states, Map<String, FrameBuilder> links) {
        states.put(this.format(state), this.frameOf(state, process, this.typeOf(state)));
        for (Link link : state.links()) {
            if (!states.containsKey(this.format(link.state())) && !link.state().type().equals((Object)State.Type.Terminal)) {
                this.framesFrom(link.state(), process, states, links);
            }
            if (links.containsKey(this.format(state) + "#" + this.format(link.state()))) continue;
            links.put(this.format(state) + "#" + this.format(link.state()), this.frameOf(state, link));
        }
    }

    private FrameBuilder frameOf(State state, Workflow.Process process, List<State.Type> types) {
        FrameBuilder builder = new FrameBuilder(new String[]{"state"}).add("name", (Object)this.format(state));
        if (!types.contains(State.Type.Intermediate)) {
            builder.add("type", types.stream().map(Enum::name).toArray(String[]::new));
        }
        if (state.task() != null) {
            if (state.task().type().equals((Object)Task.Type.Service)) {
                this.stateServices.add(this.format(state));
            }
            builder.add(state.task().type().name()).add("taskType", (Object)state.task().type().name()).add("taskName", (Object)state.task().id()).add("process", (Object)process.name$());
        }
        if (types.contains(State.Type.Terminal)) {
            state.type(State.Type.Terminal).links().clear();
        }
        return builder;
    }

    private List<State.Type> typeOf(State state) {
        ArrayList<State.Type> types = new ArrayList<State.Type>();
        if (state.type().equals((Object)State.Type.Initial)) {
            types.add(State.Type.Initial);
        }
        if (state.links().isEmpty() || ((Link)state.links().get(0)).state().type().equals((Object)State.Type.Terminal)) {
            types.add(State.Type.Terminal);
        } else if (!types.contains(State.Type.Initial)) {
            types.add(State.Type.Intermediate);
        }
        return types;
    }

    private FrameBuilder frameOf(State state, Link link) {
        return new FrameBuilder(new String[]{"link"}).add("from", (Object)this.format(state)).add("to", (Object)this.format(link.state())).add("type", (Object)link.type().name());
    }

    private String format(State state) {
        return Formatters.snakeCaseToCamelCase().format((Object)state.name().replace(" ", "_")).toString();
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

