/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.ServiceListRenderer;
import io.intino.konos.builder.codegeneration.bpm.BpmRenderer;
import io.intino.konos.builder.codegeneration.datahub.DatalakeRenderer;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterRenderer;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.feeder.FeederRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.codegeneration.sentinel.ListenerRenderer;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.compiler.shared.KonosBuildConstants;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import java.io.File;

public class FullRenderer {
    private final KonosGraph graph;
    private final CompilationContext context;
    private final boolean hasModel;

    public FullRenderer(KonosGraph graph, CompilationContext context) {
        this.graph = graph;
        this.context = context;
        this.hasModel = this.hasModel();
    }

    public void execute() {
        this.render();
    }

    private void render() {
        if (this.context.mode().equals((Object)KonosBuildConstants.Mode.Normal)) {
            this.schemas();
            this.exceptions();
            this.rest();
            this.tasks();
            this.jmx();
            this.jms();
            this.datalake();
            this.messageHub();
            this.subscribers();
            this.mounters();
            this.adapters();
            this.feeders();
            this.processes();
            this.slack();
            this.box();
            this.main();
            this.ui();
            this.context.saveCache();
        } else if (this.context.mode().equals((Object)KonosBuildConstants.Mode.OnlyElements)) {
            this.ui();
        } else {
            this.accessors();
        }
    }

    private void accessors() {
        this.graph.restServiceList().forEach(service -> new RESTAccessorRenderer(this.context, (Service.REST)((Object)service), new File(this.context.configuration().genDirectory(), "rest#" + service.name$() + File.separator + "src")).render());
        this.graph.jmxServiceList().forEach(service -> new JMXAccessorRenderer(this.context, (Service.JMX)((Object)service), new File(this.context.configuration().genDirectory(), "jmx#" + service.name$() + File.separator + "src")).render());
    }

    private void schemas() {
        new SchemaListRenderer(this.context, this.graph).execute();
    }

    private void exceptions() {
        new ExceptionRenderer(this.context, this.graph).execute();
    }

    private void rest() {
        new RESTResourceRenderer(this.context, this.graph).execute();
        new RESTServiceRenderer(this.context, this.graph).execute();
    }

    private void jmx() {
        new JMXOperationsServiceRenderer(this.context, this.graph).execute();
        new JMXServerRenderer(this.context, this.graph).execute();
    }

    private void jms() {
        new MessagingRequestRenderer(this.context, this.graph).execute();
        new MessagingServiceRenderer(this.context, this.graph).execute();
    }

    private void tasks() {
        new ListenerRenderer(this.context, this.graph).execute();
        new SentinelsRenderer(this.context, this.graph).execute();
    }

    private void datalake() {
        new DatalakeRenderer(this.context, this.graph).execute();
    }

    private void messageHub() {
        new MessageHubRenderer(this.context, this.graph).execute();
    }

    private void mounters() {
        new MounterFactoryRenderer(this.context, this.graph).execute();
        new MounterRenderer(this.context, this.graph).execute();
    }

    private void subscribers() {
        new SubscriberRenderer(this.context, this.graph).execute();
    }

    private void adapters() {
        new AdapterRenderer(this.context, this.graph).execute();
    }

    private void processes() {
        new BpmRenderer(this.context, this.graph).execute();
    }

    private void feeders() {
        new FeederRenderer(this.context, this.graph).execute();
    }

    private void slack() {
        new SlackRenderer(this.context, this.graph).execute();
    }

    private void ui() {
        ComponentRenderer.clearCache();
        if (this.context.mode() == KonosBuildConstants.Mode.Normal) {
            this.uiServer();
        }
        this.uiClient();
    }

    private void uiServer() {
        new io.intino.konos.builder.codegeneration.services.ui.ServiceListRenderer(this.context, this.graph).execute();
    }

    private void uiClient() {
        new ServiceListRenderer(this.context, this.graph).execute();
    }

    private void box() {
        AbstractBoxRenderer renderer = new AbstractBoxRenderer(this.context, this.graph, this.hasModel);
        renderer.execute();
        new BoxRenderer(this.context, this.graph, this.hasModel).execute();
        new BoxConfigurationRenderer(this.context, this.hasModel, renderer.customParameters()).execute();
    }

    private void main() {
        new MainRenderer(this.context, this.hasModel).execute();
    }

    private boolean hasModel() {
        return this.context.configuration().model() != null && this.context.configuration().model().language() != null;
    }
}

