/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.PageRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Service;
import java.util.List;

public class ResourceRenderer
extends UIRenderer {
    protected final Service.UI.Resource resource;

    public ResourceRenderer(Settings settings, Service.UI.Resource resource, Target target) {
        super(settings, target);
        this.resource = resource;
    }

    @Override
    public void render() {
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        FrameBuilder builder = this.buildFrame().add("resource").add("name", (Object)this.resource.name$()).add("parameter", (Object)this.parameters(this.resource));
        if (uiService.googleApiKey() != null) {
            builder.add("googleApiKey", (Object)Formatters.customize("googleApiKey", uiService.googleApiKey()));
        }
        if (this.resource.isConfidential()) {
            builder.add("confidential", (Object)"");
        }
        Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$()), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
        new PageRenderer(this.settings, this.resource).execute();
    }

    private FrameBuilder[] parameters(Service.UI.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("name", parameter)).toArray(FrameBuilder[]::new);
    }
}

