/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import io.intino.konos.builder.codegeneration.Cleaner;
import io.intino.konos.builder.codegeneration.ElementReference;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.helpers.CodeGenerationHelper;

public class DisplayCleaner
extends Cleaner {
    private ElementReference reference;

    public DisplayCleaner(Settings settings, ElementReference reference) {
        super(settings);
        this.reference = reference;
    }

    @Override
    public void execute() {
        System.out.println(String.format("Removed %s", this.reference.name()));
        this.clean(Target.Accessor);
        this.clean(Target.Owner);
        this.cache().remove(this.reference.toString());
    }

    public void clean(Target target) {
        String name = CodeGenerationHelper.displayFilename(this.reference.name());
        this.removePassiveViewFiles(target);
        this.remove(CodeGenerationHelper.displayFolder(this.gen(target), this.reference.type(), target), name, target);
        this.remove(CodeGenerationHelper.displayFolder(this.gen(target), this.reference.type(), target), "Abstract" + name, target);
    }

    private void removePassiveViewFiles(Target target) {
        String name = CodeGenerationHelper.displayFilename(this.reference.name());
        this.remove(CodeGenerationHelper.displayNotifierFolder(this.gen(target), target), name + "Notifier", target);
        this.remove(CodeGenerationHelper.displayNotifierFolder(this.gen(target), target), name + "ProxyNotifier", target);
        this.remove(CodeGenerationHelper.displayRequesterFolder(this.gen(target), target), name + "Requester", target);
        this.remove(CodeGenerationHelper.displayRequesterFolder(this.gen(target), target), name + "ProxyRequester", target);
        this.remove(CodeGenerationHelper.displayRequesterFolder(this.gen(target), target), name + "PushRequester", target);
    }
}

