/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.I18nTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Translator;
import java.util.List;

public class I18nRenderer
extends UIRenderer {
    private final Service.UI service;

    public I18nRenderer(Settings settings, Service.UI service, Target target) {
        super(settings, target);
        this.service = service;
    }

    @Override
    public void render() {
        FrameBuilder builder = this.buildFrame();
        Commons.write(CodeGenerationHelper.fileOf(CodeGenerationHelper.folder(this.gen(), "/", this.target), "I18n", this.target).toPath(), this.setup(this.template()).render((Object)builder.toFrame()));
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder frame = super.buildFrame().add("i18n");
        if (!this.isAlexandriaUi()) {
            frame.add("use", (Object)this.alexandriaUseFrame());
        }
        this.service.useList().forEach(use -> frame.add("use", (Object)this.frameOf((Service.UI.Use)((Object)use))));
        List<Translator> translators = this.service.graph().translatorList();
        translators.forEach(t -> frame.add("translator", (Object)this.frameOf((Translator)((Object)t))));
        return frame;
    }

    private boolean isAlexandriaUi() {
        String groupId = this.settings.moduleConfiguration().graph().artifact().groupId();
        String artifactName = this.settings.moduleConfiguration().graph().artifact().name$();
        return groupId.equalsIgnoreCase("io.intino.alexandria") && artifactName.equalsIgnoreCase("ui-framework");
    }

    private Frame alexandriaUseFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"use"});
        result.add("name", (Object)"AlexandriaUi");
        result.add("service", (Object)"alexandria-ui-elements");
        return result.toFrame();
    }

    private Frame frameOf(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"use"});
        result.add("name", (Object)use.name());
        result.add("service", (Object)use.service());
        return result.toFrame();
    }

    private Frame frameOf(Translator translator) {
        FrameBuilder result = new FrameBuilder(new String[]{"translator"});
        result.add("language", (Object)translator.language().code());
        translator.translationList().forEach(t -> result.add("translation", (Object)this.frameOf((Translator.Translation)((Object)t))));
        return result.toFrame();
    }

    private Frame frameOf(Translator.Translation translation) {
        FrameBuilder result = new FrameBuilder(new String[]{"translation"});
        result.add("text", (Object)translation.text());
        result.add("value", (Object)translation.value());
        return result.toFrame();
    }

    private Template template() {
        return this.target == Target.Accessor ? new io.intino.konos.builder.codegeneration.accessor.ui.templates.I18nTemplate() : new I18nTemplate();
    }
}

