/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.sentinel;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SentinelsRenderer
extends Renderer {
    private final List<Sentinel> sentinels;

    public SentinelsRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.sentinels = graph.sentinelList();
    }

    @Override
    public void render() {
        if (this.sentinels.isEmpty()) {
            return;
        }
        Commons.writeFrame(this.gen(), "Sentinels", this.template().render((Object)new FrameBuilder(new String[]{"Sentinels"}).add("package", (Object)this.packageName()).add("box", (Object)this.boxName()).add("sentinel", (Object)this.processSentinels()).toFrame()));
    }

    private Frame[] processSentinels() {
        ArrayList list = new ArrayList();
        list.addAll(this.sentinels.stream().filter(t -> t.i$(Sentinel.SystemListener.class)).map(t -> (Sentinel.SystemListener)t.a$(Sentinel.SystemListener.class)).map(this::processSentinel).collect(Collectors.toList()));
        list.addAll(this.sentinels.stream().filter(t -> t.i$(Sentinel.DirectoryListener.class)).map(t -> (Sentinel.DirectoryListener)t.a$(Sentinel.DirectoryListener.class)).map(this::processDirectoryListenerSentinel).collect(Collectors.toList()));
        return list.toArray(new Frame[0]);
    }

    private Frame processSentinel(Sentinel.SystemListener task) {
        FrameBuilder builder = new FrameBuilder().add("sentinel").add(((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.name$());
        ArrayList<Frame> jobFrames = new ArrayList<Frame>();
        if (task.i$(Sentinel.ClockListener.class)) {
            Sentinel.ClockListener cron = (Sentinel.ClockListener)task.a$(Sentinel.ClockListener.class);
            FrameBuilder jobFrameBuilder = new FrameBuilder().add("job").add("Cron" + ((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.core$().id());
            jobFrameBuilder.add("cronTrigger").add("pattern", (Object)cron.pattern()).add("mean", (Object)cron.mean());
            if (cron.timeZone() != null) {
                jobFrameBuilder.add("timeZone", (Object)cron.timeZone());
            }
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        if (task.i$(Sentinel.BootListener.class)) {
            FrameBuilder jobFrameBuilder = new FrameBuilder(new String[]{"onBootTrigger", "job", "Boot" + ((Object)((Object)task)).getClass().getSimpleName()}).add("name", (Object)task.core$().id());
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        builder.add("job", (Object)jobFrames.toArray(new Frame[0]));
        return builder.toFrame();
    }

    private Frame processDirectoryListenerSentinel(Sentinel.DirectoryListener sentinel) {
        FrameBuilder builder = new FrameBuilder().add("sentinel").add(((Object)((Object)sentinel)).getClass().getSimpleName()).add("event", sentinel.events().stream().map(Enum::name).toArray(String[]::new)).add("file", (Object)(sentinel.directories() == null ? "" : sentinel.directories().get(0))).add("name", (Object)sentinel.name$()).add("package", (Object)this.packageName());
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new SentinelsTemplate());
    }
}

