/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaListRenderer
extends Renderer {
    private final List<Service> services;
    private final List<Schema> schemas;
    private final File destination;
    private final String packageName;

    public SchemaListRenderer(Settings settings, KonosGraph graph) {
        this(settings, graph, null);
    }

    public SchemaListRenderer(Settings settings, KonosGraph graph, File destination) {
        this(settings, graph, destination, null);
    }

    public SchemaListRenderer(Settings settings, KonosGraph graph, File destination, String packageName) {
        super(settings, Target.Owner);
        this.schemas = graph.core$().find(Schema.class).stream().filter(s -> !s.core$().owner().is(Schema.class)).collect(Collectors.toList());
        this.services = graph.serviceList();
        this.destination = destination != null ? destination : this.gen();
        this.packageName = packageName != null ? packageName : settings.packageName();
    }

    public void clean() {
        List serviceFolders = this.services.stream().map(this::serviceFolder).filter(File::exists).collect(Collectors.toList());
        if (this.serviceFolder(null).exists()) {
            serviceFolders.add(this.serviceFolder(null));
        }
        if (serviceFolders.size() <= 0) {
            return;
        }
        List filenames = this.schemas.stream().map(s -> Commons.javaFile(this.schemaFolder((Schema)((Object)s)), s.name$()).getAbsolutePath()).collect(Collectors.toList());
        List<File> filesToDelete = serviceFolders.stream().map(f -> Arrays.asList(Objects.requireNonNull(f.listFiles()))).flatMap(Collection::stream).filter(f -> !filenames.contains(f.getAbsolutePath())).collect(Collectors.toList());
        filesToDelete.forEach(File::delete);
    }

    @Override
    public void render() {
        this.schemas.forEach(s -> new SchemaRenderer(this.settings, (Schema)((Object)s), this.destination, this.packageName).execute());
    }

    private String subPackage(Schema schema) {
        return this.subPackage((Service)schema.core$().ownerAs(Service.class));
    }

    private String subPackage(Service service) {
        return "schemas" + (String)(service != null ? File.separator + service.name$().toLowerCase() : "");
    }

    private File schemaFolder(Schema schema) {
        return new File(this.destination, this.subPackage(schema));
    }

    private File serviceFolder(Service service) {
        return new File(this.destination, this.subPackage(service));
    }
}

