/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.cache;

import io.intino.konos.builder.codegeneration.ElementReference;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.utils.StoreAuditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ElementCache
extends HashMap<String, String> {
    private final ElementHelper elementHelper = new ElementHelper();
    final StoreAuditor auditor;

    public ElementCache() {
        this(null, Collections.emptyMap());
    }

    public ElementCache(StoreAuditor auditor) {
        this(auditor, Collections.emptyMap());
    }

    public ElementCache(StoreAuditor auditor, Map<String, String> elements) {
        this.auditor = auditor;
        this.init(elements);
    }

    private void init(Map<String, String> elements) {
        this.putAll(elements);
    }

    public ElementCache add(Layer element) {
        ElementReference reference = new ElementReference().name(this.elementHelper.nameOf(element)).type(this.elementHelper.typeOf(element)).context(ElementReference.Context.from(element));
        this.put(element.core$().id(), reference.toString());
        return this;
    }

    @Override
    public ElementCache clone() {
        ElementCache elementCache = new ElementCache(this.auditor);
        elementCache.putAll(this);
        return elementCache;
    }

    public boolean isDirty(Layer element) {
        return this.auditor == null || this.auditor.isModified(element.core$()) || this.auditor.isCreated(element.core$());
    }

    public List<ElementReference> removeList() {
        List removeList = this.auditor != null ? this.auditor.changeList().stream().filter(c -> c.action() == StoreAuditor.Action.Removed).collect(Collectors.toList()) : Collections.emptyList();
        return removeList.stream().filter(c -> this.containsKey(c.nodeId())).map(c -> ElementReference.from((String)this.get(c.nodeId()))).collect(Collectors.toList());
    }
}

