/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.ArtifactTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Service;
import io.intino.plugin.dependencyresolution.DependencyCatalog;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import io.intino.tara.plugin.project.configuration.ConfigurationManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class ServiceCreator
extends UIRenderer {
    private static final String LegioArtifact = "artifact.legio";
    private final Project project;
    private final Service.UI service;

    public ServiceCreator(Settings settings, Service.UI service) {
        super(settings, Target.Accessor);
        this.project = settings.module() == null ? null : settings.module().getProject();
        this.service = service;
    }

    @Override
    public void render() {
        try {
            if (this.settings.module() == null) {
                return;
            }
            boolean exists = this.findModule(this.service.name$()) != null;
            this.settings.webModule(this.getOrCreateModule());
            if (!exists) {
                this.createSkeleton();
            }
            new ServiceRenderer(this.settings, this.service).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Module getOrCreateModule() {
        Module m = this.findModule(this.service.name$());
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (m != null) {
                this.addWebDependency(TaraUtil.configurationOf((Module)m));
                return;
            }
            ModuleManager manager = ModuleManager.getInstance((Project)this.project);
            Module webModule = manager.newModule(this.moduleImlFilename(this.service), "WEB_MODULE");
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)webModule).getModifiableModel();
            File moduleRoot = new File(webModule.getModuleFilePath()).getParentFile();
            moduleRoot.mkdirs();
            VirtualFile file = VfsUtil.findFile((Path)moduleRoot.toPath(), (boolean)true);
            if (file != null) {
                model.addContentEntry(file);
            }
            model.commit();
            boolean created = this.createConfigurationFile(moduleRoot, this.service.name$());
            if (created) {
                this.addWebDependency(ConfigurationManager.register((Module)webModule, (Configuration)ConfigurationManager.newExternalProvider((Module)webModule)));
            }
        }));
        return this.findModule(this.service.name$());
    }

    private boolean createConfigurationFile(File moduleRoot, String name) {
        Configuration configuration = TaraUtil.configurationOf((Module)this.settings.module());
        FrameBuilder builder = new FrameBuilder(new String[]{"artifact", "legio"});
        builder.add("groupId", (Object)configuration.groupId());
        builder.add("artifactId", (Object)Formatters.camelCaseToSnakeCase().format((Object)name).toString());
        builder.add("version", (Object)configuration.version());
        Map<String, List<String>> repositories = this.reduce(configuration.releaseRepositories());
        for (String id : repositories.keySet()) {
            FrameBuilder repoFrameBuilder = new FrameBuilder(new String[]{"repository", "release"}).add("id", (Object)id);
            for (String url : repositories.get(id)) {
                repoFrameBuilder.add("url", (Object)url);
            }
            builder.add("repository", (Object)repoFrameBuilder);
        }
        File file = new File(moduleRoot, LegioArtifact);
        if (!file.exists()) {
            Commons.write(file.toPath(), new ArtifactTemplate().render(builder));
            return true;
        }
        return false;
    }

    private void createSkeleton() throws IOException {
        File destiny = this.root();
        File file = new File(destiny, "ui.zip");
        this.copyResourcesRecursively(this.getClass().getResource("/ui/ui.zip"), file);
        ZipUtil.extract((File)file, (File)destiny, null, (boolean)false);
        file.delete();
        new File(destiny, "images").mkdirs();
    }

    private void copyResourcesRecursively(URL originUrl, File destination) {
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
            } else {
                FileUtils.copyFile((File)new File(originUrl.getPath()), (File)destination);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
        }
    }

    private void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                finally {
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }

    private Map<String, List<String>> reduce(Map<String, String> map) {
        HashMap<String, List<String>> reduced = new HashMap<String, List<String>>();
        map.forEach((key, value) -> {
            reduced.putIfAbsent((String)value, new ArrayList());
            ((List)reduced.get(value)).add(key);
        });
        return reduced;
    }

    private void addWebDependency(Configuration webConf) {
        boolean added = ((LegioConfiguration)TaraUtil.configurationOf((Module)this.settings.module())).addDependency(DependencyCatalog.DependencyScope.WEB, webConf.groupId() + ":" + webConf.artifactId() + ":" + webConf.version());
        if (added) {
            webConf.reload();
        }
    }

    private Module findModule(String name) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> Arrays.stream(ModuleManager.getInstance((Project)this.project).getModules()).filter(m -> m.getName().equals(this.toSnakeCase(name))).findFirst().orElse(null));
    }

    private String toSnakeCase(String name) {
        return (String)Formatters.camelCaseToSnakeCase().format((Object)name);
    }

    @NotNull
    private String moduleImlFilename(Service.UI service) {
        String string = this.project.getBasePath() + File.separator + this.toSnakeCase(service.name$()) + File.separator + this.toSnakeCase(service.name$()) + ".iml";
        if (string == null) {
            ServiceCreator.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/accessor/ui/ServiceCreator", "moduleImlFilename"));
    }
}

