/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.Map;

public abstract class Renderer {
    protected final Settings settings;
    protected final ElementHelper elementHelper;
    protected final Target target;

    protected Renderer(Settings settings, Target target) {
        this.settings = settings;
        this.elementHelper = new ElementHelper();
        this.target = target;
    }

    public void execute() {
        this.render();
    }

    protected abstract void render();

    public Project project() {
        return this.settings.project();
    }

    public String boxName() {
        return this.settings.boxName();
    }

    protected Configuration configuration() {
        return this.module() != null ? TaraUtil.configurationOf((Module)this.module()) : null;
    }

    protected String packageName() {
        return this.settings.packageName();
    }

    protected Module module() {
        return this.settings.module();
    }

    protected String parent() {
        return this.settings.parent();
    }

    protected File root() {
        return this.settings.root(this.target);
    }

    protected File res() {
        return this.settings.res(this.target);
    }

    protected File src() {
        return this.settings.src(this.target);
    }

    protected File gen() {
        return this.settings.gen(this.target);
    }

    protected Map<String, String> classes() {
        return this.settings.classes();
    }

    protected ElementCache cache() {
        return this.settings.cache();
    }

    public FrameBuilder buildBaseFrame() {
        return new FrameBuilder().add("box", (Object)this.boxName()).add("package", (Object)this.settings.packageName());
    }

    protected boolean isRendered(Layer element) {
        if (element == null) {
            return false;
        }
        if (element.i$(CatalogComponents.Collection.Mold.Item.class)) {
            return false;
        }
        if (element.i$(HelperComponents.Row.class)) {
            return false;
        }
        return !this.cache().isDirty(element);
    }

    protected boolean isRoot(Layer element) {
        return element.core$().owner() == null || element.core$().owner() == element.core$().model();
    }

    protected void saveRendered(Layer element) {
        this.settings.cache().add(element);
    }
}

