/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.FullCleaner;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.accessor.ui.ServiceListRenderer;
import io.intino.konos.builder.codegeneration.bpm.BpmRenderer;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.codegeneration.datahub.DatalakeRenderer;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterRenderer;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.feeder.FeederRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.codegeneration.sentinel.ListenerRenderer;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.plugin.codeinsight.linemarkers.InterfaceToJavaImplementation;
import io.intino.plugin.dependencyresolution.LanguageResolver;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullRenderer {
    @Nullable
    private final KonosGraph graph;
    private final Settings settings;
    private final boolean hasModel;

    public FullRenderer(KonosGraph graph, Settings settings) {
        this.graph = graph;
        this.settings = settings;
        this.settings.parent(this.parent());
        this.hasModel = this.hasModel();
    }

    public void execute() {
        this.clean();
        this.render();
    }

    private void clean() {
        new FullCleaner(this.settings, this.graph).execute();
    }

    private void render() {
        this.schemas();
        this.exceptions();
        this.rest();
        this.tasks();
        this.jmx();
        this.jms();
        this.datalake();
        this.messageHub();
        this.subscribers();
        this.mounters();
        this.adapters();
        this.feeders();
        this.processes();
        this.slack();
        this.ui();
        this.box();
        this.main();
        InterfaceToJavaImplementation.nodeMap.clear();
        InterfaceToJavaImplementation.nodeMap.putAll(this.settings.classes());
    }

    private void schemas() {
        new SchemaListRenderer(this.settings, this.graph).execute();
    }

    private void exceptions() {
        new ExceptionRenderer(this.settings, this.graph).execute();
    }

    private void rest() {
        new RESTResourceRenderer(this.settings, this.graph).execute();
        new RESTServiceRenderer(this.settings, this.graph).execute();
    }

    private void jmx() {
        new JMXOperationsServiceRenderer(this.settings, this.graph).execute();
        new JMXServerRenderer(this.settings, this.graph).execute();
    }

    private void jms() {
        new MessagingRequestRenderer(this.settings, this.graph).execute();
        new MessagingServiceRenderer(this.settings, this.graph).execute();
    }

    private void tasks() {
        new ListenerRenderer(this.settings, this.graph).execute();
        new SentinelsRenderer(this.settings, this.graph).execute();
    }

    private void datalake() {
        new DatalakeRenderer(this.settings, this.graph).execute();
    }

    private void messageHub() {
        new MessageHubRenderer(this.settings, this.graph).execute();
    }

    private void mounters() {
        new MounterFactoryRenderer(this.settings, this.graph).execute();
        new MounterRenderer(this.settings, this.graph).execute();
    }

    private void subscribers() {
        new SubscriberRenderer(this.settings, this.graph).execute();
    }

    private void adapters() {
        new AdapterRenderer(this.settings, this.graph).execute();
    }

    private void processes() {
        new BpmRenderer(this.settings, this.graph).execute();
    }

    private void feeders() {
        new FeederRenderer(this.settings, this.graph).execute();
    }

    private void slack() {
        new SlackRenderer(this.settings, this.graph).execute();
    }

    private void ui() {
        ElementCache cache = this.settings.cache();
        ComponentRenderer.clearCache();
        ElementCache serverCache = cache.clone();
        this.uiServer(serverCache);
        this.uiClient(cache.clone());
        cache.putAll(serverCache);
    }

    private void uiServer(ElementCache cache) {
        new io.intino.konos.builder.codegeneration.services.ui.ServiceListRenderer(this.settings.clone().cache(cache), this.graph).execute();
    }

    private void uiClient(ElementCache cache) {
        new ServiceListRenderer(this.settings.clone().cache(cache), this.graph).execute();
    }

    private void box() {
        AbstractBoxRenderer renderer = new AbstractBoxRenderer(this.settings, this.graph, this.hasModel);
        renderer.execute();
        new BoxRenderer(this.settings, this.graph, this.hasModel).execute();
        new BoxConfigurationRenderer(this.settings, this.hasModel, renderer.customParameters()).execute();
    }

    private void main() {
        new MainRenderer(this.settings, this.graph, this.hasModel).execute();
    }

    private String parent() {
        Module module = this.settings.module();
        try {
            if (module == null) {
                return null;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            Configuration configuration = TaraUtil.configurationOf((Module)module);
            if (configuration.model() == null) {
                return null;
            }
            Configuration.Model.ModelLanguage language = configuration.model().language();
            if (language == null || language.generationPackage() == null) {
                return null;
            }
            String workingPackage = language.generationPackage().replace(".graph", "");
            String artifact = LanguageResolver.languageId((String)language.name(), (String)language.effectiveVersion()).split(":")[1];
            Application application = ApplicationManager.getApplication();
            PsiClass aClass = (PsiClass)application.runReadAction(() -> facade.findClass(this.parentBoxName(workingPackage, artifact), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)));
            if (aClass == null) {
                aClass = (PsiClass)application.runReadAction(() -> facade.findClass(this.parentBoxName(workingPackage, language.name()), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)));
            }
            if (aClass != null) {
                return workingPackage.toLowerCase() + ".box." + Formatters.firstUpperCase(language.name());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    @NotNull
    private String parentBoxName(String workingPackage, String name) {
        String string = workingPackage + ".box." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)name).toString()) + "Box";
        if (string == null) {
            FullRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private boolean hasModel() {
        Module module = this.settings.module();
        return module != null && TaraUtil.configurationOf((Module)module) != null && this.hasModel(TaraUtil.configurationOf((Module)module));
    }

    private boolean hasModel(Configuration configuration) {
        return configuration.model() != null && configuration.model().language() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/FullRenderer", "parentBoxName"));
    }
}

