/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.helpers.Commons;
import io.intino.legio.graph.Parameter;
import io.intino.plugin.project.LegioConfiguration;
import java.util.Set;

public class BoxConfigurationRenderer
extends Renderer {
    private final LegioConfiguration configuration;
    private final Set<String> params;
    private boolean isTara;

    BoxConfigurationRenderer(Settings settings, boolean isTara, Set<String> params) {
        super(settings, Target.Owner);
        this.isTara = isTara;
        this.params = params;
        this.configuration = settings.moduleConfiguration();
        if (this.configuration != null) {
            for (Parameter parameter : this.configuration.graph().artifact().parameterList()) {
                this.params.add(parameter.name());
            }
        }
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(builder);
        Commons.writeFrame(this.gen(), StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().render((Object)builder.toFrame()));
    }

    private String fillFrame(FrameBuilder builder) {
        String boxName = this.settings.boxName();
        builder.add("name", (Object)boxName).add("package", (Object)this.packageName());
        if (this.parent() != null && this.configuration != null && this.configuration.model() != null && !this.configuration.model().level().isPlatform()) {
            builder.add("parent", (Object)this.parent());
        }
        if (this.isTara) {
            builder.add("tara", (Object)"");
        }
        for (String parameter : this.params) {
            if (parameter.equalsIgnoreCase("home")) continue;
            builder.add("parameter", (Object)new FrameBuilder().add("name", (Object)this.nameOf(parameter)).add("value", (Object)parameter));
        }
        return boxName;
    }

    private String nameOf(String parameter) {
        return parameter.replace("-", " ").replace("_", " ");
    }

    private Template template() {
        return Formatters.customize(new BoxConfigurationTemplate());
    }
}

