/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PsiTestUtil;
import cottons.utils.Files;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.Manifest;
import io.intino.konos.builder.actions.KonosAction;
import io.intino.konos.builder.codegeneration.FullRenderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.cache.CacheReader;
import io.intino.konos.builder.codegeneration.cache.CacheWriter;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.legio.graph.Artifact;
import io.intino.plugin.IntinoException;
import io.intino.plugin.dependencyresolution.DependencyCatalog;
import io.intino.plugin.project.IntinoDirectory;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.plugin.project.LibraryConflictResolver;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Stash;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateKonosBoxAction
extends KonosAction {
    private static final Logger LOG = Logger.getInstance((String)"CreateKonosBoxAction: ");
    private static final String BOX = "box";
    private static final String TEXT = "Create Konos Box";
    private static Map<String, Boolean> firstTimeMap = new HashMap<String, Boolean>();

    public CreateKonosBoxAction() {
        super(TEXT, "Creates Konos Box", KonosIcons.GENERATE_16);
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control alt S"}));
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(KonosIcons.GENERATE_16);
        super.update(e);
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null) {
            e.getPresentation().setText("Create Konos Box for " + module.getName() + " (" + file.getParentFile().getName() + ")");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (this.noProject(e, project) || module == null) {
            return;
        }
        project.save();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.withTask(new Task.Backgroundable(project, module.getName() + ": Generating box...", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                KonosGraph konosGraph;
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((konosGraph = new KonosGenerator(module).generate(TaraUtil.getSrcRoot((Module)module), CreateKonosBoxAction.this.getGenRoot(module), CreateKonosBoxAction.this.getResRoot(module))) != null) {
                    ApplicationManager.getApplication().invokeLater(() -> CreateKonosBoxAction.this.updateDependencies(module, CreateKonosBoxAction.this.requiredDependencies(konosGraph)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "io/intino/konos/builder/actions/CreateKonosBoxAction$1", "run"));
            }
        });
    }

    private void updateDependencies(Module module, Map<String, String> requiredLibraries) {
        LegioConfiguration conf = (LegioConfiguration)TaraUtil.configurationOf((Module)module);
        if (conf.groupId().equals("io.intino.alexandria")) {
            return;
        }
        List toAdd = conf.graph().artifact().imports().dependencyList();
        List libraries = Arrays.stream(ModuleRootManager.getInstance((Module)module).getModifiableModel().getOrderEntries()).filter(o -> o instanceof LibraryOrderEntry).collect(Collectors.toList());
        List<String> collect = requiredLibraries.keySet().stream().filter(dep -> !this.isInModule(libraries, dep + ":" + (String)requiredLibraries.get(dep)) && this.findDependency(toAdd, (String)dep) == null || (conf.groupId() + ":" + conf.artifactId()).equals(dep)).map(dep -> dep + ":" + (String)requiredLibraries.get(dep)).collect(Collectors.toList());
        collect.forEach(d -> conf.addDependency(DependencyCatalog.DependencyScope.COMPILE, d));
        conf.updateCompileDependencies(requiredLibraries.keySet().stream().filter(dep -> {
            Artifact.Imports.Dependency dependency = this.findDependency(toAdd, (String)dep);
            return dependency != null && this.isOlder(dependency, (String)requiredLibraries.get(dep));
        }).map(dep -> dep + ":" + (String)requiredLibraries.get(dep)).collect(Collectors.toList()));
        conf.reload();
    }

    private boolean isInModule(List<OrderEntry> libraries, String dep) {
        return libraries.stream().anyMatch(library -> ((LibraryOrderEntry)library).getLibraryName().endsWith(dep));
    }

    private boolean isOlder(Artifact.Imports.Dependency dependency, String version) {
        try {
            String dependencyVersion;
            String string = dependencyVersion = dependency.effectiveVersion().isEmpty() ? dependency.version() : dependency.effectiveVersion();
            if (LibraryConflictResolver.VersionRange.isRange((String)dependencyVersion)) {
                return !LibraryConflictResolver.VersionRange.isInRange((String)version, (List)LibraryConflictResolver.VersionRange.rangeValuesOf((String)dependencyVersion));
            }
            if (dependencyVersion.isEmpty()) {
                return false;
            }
            if (version.isEmpty()) {
                return true;
            }
            return new LibraryConflictResolver.Version(dependencyVersion).compareTo(new LibraryConflictResolver.Version(version)) < 0;
        }
        catch (IntinoException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private Artifact.Imports.Dependency findDependency(List<Artifact.Imports.Dependency> dependencies, String artifact) {
        return dependencies.stream().filter(dependency -> artifact.equals(dependency.groupId() + ":" + dependency.artifactId())).findFirst().orElse(null);
    }

    private Map<String, String> requiredDependencies(KonosGraph graph) {
        Map<String, String> dependencies = Manifest.load().dependencies;
        if (graph.jmxServiceList().isEmpty()) {
            this.remove(dependencies, "jmx");
        }
        if (graph.messagingServiceList().isEmpty()) {
            this.remove(dependencies, ":jms");
        }
        if (graph.sentinelList().isEmpty()) {
            this.remove(dependencies, "scheduler");
        }
        if (graph.datalake() == null) {
            this.remove(dependencies, "datalake");
            this.remove(dependencies, "sshj");
        } else if (!graph.datalake().isSshMirrored()) {
            this.remove(dependencies, "sshj");
        }
        if (graph.messageHub() == null) {
            this.remove(dependencies, "message");
            this.remove(dependencies, "terminal-jms");
        }
        if (graph.messageHub() != null && !graph.messageHub().isJmsBus()) {
            this.remove(dependencies, "terminal-jms");
        }
        if (graph.uiServiceList().isEmpty()) {
            this.remove(dependencies, "ui");
        }
        if (graph.restServiceList().isEmpty()) {
            this.remove(dependencies, "rest");
        }
        if (graph.workflow() == null) {
            this.remove(dependencies, "bpm");
        }
        if (graph.slackBotServiceList().isEmpty()) {
            this.remove(dependencies, "slack");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().chartList(c -> c.isAbsolute() || c.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-r");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().dashboardList(d -> d.isAbsolute() || d.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-shiny");
        }
        return dependencies;
    }

    private void remove(Map<String, String> dependencies, String type) {
        String toRemove = null;
        for (String dep : dependencies.keySet()) {
            if (!dep.contains(type)) continue;
            toRemove = dep;
        }
        if (toRemove != null) {
            dependencies.remove(toRemove);
        }
    }

    private boolean noProject(AnActionEvent e, Project project) {
        if (project == null) {
            LOG.error("actionPerformed: no project for " + e);
            return true;
        }
        return false;
    }

    private VirtualFile createDirectory(Module module, String name) {
        Application a = ApplicationManager.getApplication();
        if (!a.isWriteAccessAllowed()) {
            a.invokeAndWait(() -> a.runWriteAction(() -> this.create(module, name)));
            if (name.equalsIgnoreCase("gen")) {
                return this.getGenRoot(module);
            }
            if (name.equalsIgnoreCase("res")) {
                return this.getResRoot(module);
            }
            return null;
        }
        return this.create(module, name);
    }

    @Nullable
    private VirtualFile create(Module module, String name) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        try {
            return VfsUtil.createDirectoryIfMissing((VirtualFile)contentRoots[0], (String)name);
        }
        catch (IOException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e);
            File file = new File(contentRoots[0].getPath(), name);
            file.mkdirs();
            return VfsUtil.findFileByIoFile((File)file, (boolean)true);
        }
    }

    private void withTask(Task.Backgroundable runnable) {
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(runnable, (ProgressIndicator)new BackgroundableProcessIndicator(runnable));
    }

    private VirtualFile getGenRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"gen".equals(file.getName())) continue;
            return file;
        }
        VirtualFile genDirectory = this.createDirectory(module, "gen");
        if (genDirectory == null) {
            return null;
        }
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)genDirectory, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        return genDirectory;
    }

    private VirtualFile getResRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"res".equals(file.getName())) continue;
            return file;
        }
        VirtualFile resDirectory = this.createDirectory(module, "res");
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)resDirectory, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        return resDirectory;
    }

    private File prepareIntinoFolder(Module module) {
        String intinoFolder = IntinoDirectory.of((Project)module.getProject()) + "/box/" + module.getName();
        File folder = new File(intinoFolder);
        if (folder.exists() && !firstTimeMap.containsKey(intinoFolder)) {
            Files.removeDir((File)folder);
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        firstTimeMap.put(intinoFolder, true);
        return folder;
    }

    private ElementCache loadCache(File folder, KonosGraph graph, Stash stash) {
        return new CacheReader(folder).load(graph, stash);
    }

    private void saveCache(ElementCache cache, File folder) {
        new CacheWriter(folder).save(cache);
    }

    private class KonosGenerator {
        private final Module module;

        KonosGenerator(Module module) {
            this.module = module;
        }

        KonosGraph generate(VirtualFile srcDirectory, VirtualFile genDirectory, VirtualFile resDirectory) {
            if (genDirectory == null) {
                this.notifyError("gen source root not found.");
                return null;
            }
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String generationPackage = configuration == null || configuration.box() == null ? CreateKonosBoxAction.BOX : configuration.workingPackage() + (String)(configuration.box().targetPackage().isEmpty() ? "" : "." + configuration.box().targetPackage());
            File gen = new File(genDirectory.getPath(), generationPackage.replace(".", File.separator));
            gen.mkdirs();
            File src = new File(srcDirectory.getPath(), generationPackage.replace(".", File.separator));
            src.mkdirs();
            return this.generate(generationPackage, gen, src, new File(resDirectory.getPath()));
        }

        private KonosGraph generate(String packageName, File gen, File src, File res) {
            GraphLoader graphLoader = new GraphLoader();
            KonosGraph graph = graphLoader.loadGraph(this.module);
            if (graph == null) {
                this.notifyError("Models have errors");
                return null;
            }
            if (!this.render(packageName, gen, src, res, graph, graphLoader.konosStash())) {
                return null;
            }
            this.refreshDirectories(gen, src, res);
            this.notifySuccess();
            return graph;
        }

        private void refreshDirectories(File gen, File src, File res) {
            this.refreshDirectory(gen);
            this.refreshDirectory(src);
            this.refreshDirectory(res);
        }

        private boolean render(String packageName, File gen, File src, File res, KonosGraph graph, Stash stash) {
            try {
                File folder = CreateKonosBoxAction.this.prepareIntinoFolder(this.module);
                ElementCache cache = CreateKonosBoxAction.this.loadCache(folder, graph, stash);
                new FullRenderer(graph, new Settings(this.module, src, gen, res, packageName, cache)).execute();
                CreateKonosBoxAction.this.saveCache(cache, folder);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).error(e.getMessage(), (Throwable)e);
                this.notifyError(e.getMessage() == null ? e.toString() : e.getMessage());
                return false;
            }
            return true;
        }

        private void notifySuccess() {
            VirtualFile genRoot = CreateKonosBoxAction.this.getGenRoot(this.module);
            if (genRoot != null) {
                Notifications.Bus.notify((Notification)new Notification("Boxing", "Services for " + this.module.getName(), "Generated", NotificationType.INFORMATION), (Project)this.module.getProject());
            }
        }

        private void notifyError(String message) {
            Notifications.Bus.notify((Notification)new Notification("Boxing", "Services cannot be generated", message, NotificationType.ERROR), (Project)this.module.getProject());
        }

        private void refreshDirectory(File dir) {
            VirtualFile vDir = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
            if (vDir == null || !vDir.isValid()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{vDir});
            vDir.refresh(true, true);
        }
    }
}

