/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Display
extends PassiveView
implements Terminal {
    protected List<Component> components = new ArrayList<Component>();
    protected String parentDisplay;
    protected List<String> parameters = new ArrayList<String>();
    protected List<Block> blockList = new ArrayList<Block>();
    protected Accessible _accessible;
    protected Decorated _decorated;

    public Display(Node node) {
        super(node);
    }

    public List<Component> components() {
        return this.components;
    }

    public Component components(int index) {
        return this.components.get(index);
    }

    public List<Component> components(Predicate<Component> predicate) {
        return this.components().stream().filter(predicate).collect(Collectors.toList());
    }

    public String parentDisplay() {
        return this.parentDisplay;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String parameters(int index) {
        return this.parameters.get(index);
    }

    public List<String> parameters(Predicate<String> predicate) {
        return this.parameters().stream().filter(predicate).collect(Collectors.toList());
    }

    public Display parentDisplay(String value) {
        this.parentDisplay = value;
        return this;
    }

    public List<Block> blockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public Block block(int index) {
        return this.blockList.get(index);
    }

    public List<Block> blockList(Predicate<Block> predicate) {
        return this.blockList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Decorated asDecorated() {
        Layer as = this.a$(Decorated.class);
        return as != null ? (Decorated)as : (Decorated)this.core$().addAspect(Decorated.class);
    }

    public boolean isDecorated() {
        return this.core$().is(Decorated.class);
    }

    public Accessible asAccessible() {
        Layer as = this.a$(Accessible.class);
        return as != null ? (Accessible)as : (Accessible)this.core$().addAspect(Accessible.class);
    }

    public boolean isAccessible() {
        return this.core$().is(Accessible.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("components", this.components);
        map.put("parentDisplay", new ArrayList<String>(Collections.singletonList(this.parentDisplay)));
        map.put("parameters", this.parameters);
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Block")) {
            this.blockList.add((Block)node.as(Block.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Block")) {
            this.blockList.remove(node.as(Block.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("components")) {
            this.components = NodeLoader.load(values, Component.class, (Layer)this);
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("parameters")) {
            this.parameters = StringLoader.load(values, (Layer)this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("components")) {
            this.components = values.stream().map(s -> (Component)this.graph().core$().load(((Layer)s).core$().id()).as(Component.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)values.get(0);
        } else if (name.equalsIgnoreCase("parameters")) {
            this.parameters = new ArrayList(values);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Decorated
    extends Layer
    implements Terminal {
        protected Display _display;

        public Decorated(Node node) {
            super(node);
        }

        public List<Component> components() {
            return this._display.components();
        }

        public Component components(int index) {
            return this._display.components().get(index);
        }

        public String parentDisplay() {
            return this._display.parentDisplay();
        }

        public List<String> parameters() {
            return this._display.parameters();
        }

        public String parameters(int index) {
            return this._display.parameters().get(index);
        }

        public Decorated parentDisplay(String value) {
            this._display.parentDisplay(value);
            return this;
        }

        public List<Block> blockList() {
            return this._display.blockList();
        }

        public Block blockList(int index) {
            return this._display.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._display.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._display.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._display.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._display.notificationList().get(index);
        }

        public Display asDisplay() {
            return (Display)this.a$(Display.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Display) {
                this._display = (Display)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Decorated.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Decorated.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Decorated.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Block block() {
                Block newElement = (Block)Decorated.this.core$().graph().concept(Block.class).createNode(this.name, Decorated.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Decorated.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Decorated.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Decorated.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Decorated.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Accessible
    extends Layer
    implements Terminal {
        protected Display _display;

        public Accessible(Node node) {
            super(node);
        }

        public List<Component> components() {
            return this._display.components();
        }

        public Component components(int index) {
            return this._display.components().get(index);
        }

        public String parentDisplay() {
            return this._display.parentDisplay();
        }

        public List<String> parameters() {
            return this._display.parameters();
        }

        public String parameters(int index) {
            return this._display.parameters().get(index);
        }

        public Accessible parentDisplay(String value) {
            this._display.parentDisplay(value);
            return this;
        }

        public List<Block> blockList() {
            return this._display.blockList();
        }

        public Block blockList(int index) {
            return this._display.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._display.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._display.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._display.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._display.notificationList().get(index);
        }

        public Display asDisplay() {
            return (Display)this.a$(Display.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Display) {
                this._display = (Display)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Accessible.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Accessible.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Accessible.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Block block() {
                Block newElement = (Block)Accessible.this.core$().graph().concept(Block.class).createNode(this.name, Accessible.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Accessible.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Accessible.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Accessible.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Accessible.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public class Clear
    extends PassiveView.Clear {
        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(Display.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends PassiveView.Create {
        public Create(String name) {
            super(name);
        }

        public Block block() {
            Block newElement = (Block)Display.this.core$().graph().concept(Block.class).createNode(this.name, Display.this.core$()).as(Block.class);
            return newElement;
        }
    }
}

