/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import io.intino.konos.builder.file.KonosFileType;
import io.intino.tara.plugin.lang.psi.TaraModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KonosUtils {
    public static List<PsiFile> findKonosFiles(Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        Application application = ApplicationManager.getApplication();
        return application.isReadAccessAllowed() ? KonosUtils.konosFiles(module) : (List)application.runReadAction(() -> KonosUtils.konosFiles(module));
    }

    private static List<PsiFile> konosFiles(Module module) {
        ArrayList<PsiFile> konosFiles = new ArrayList<PsiFile>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(ID.create((String)"filetypes"), (Object)KonosFileType.instance(), GlobalSearchScope.moduleScope((Module)module));
        files.stream().filter(o -> o != null && !o.getCanonicalFile().getName().contains("Misc")).forEach(file -> {
            TaraModel konosFile = (TaraModel)PsiManager.getInstance((Project)module.getProject()).findFile(file);
            if (konosFile != null) {
                konosFiles.add((PsiFile)konosFile);
            }
        });
        return konosFiles;
    }
}

