/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.passiveview;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.templates.DisplayTemplate;
import io.intino.konos.builder.codegeneration.ui.passiveview.PassiveViewRenderer;
import io.intino.konos.model.graph.PassiveView;
import java.io.File;

public class PassiveViewUpdater<C extends PassiveView>
extends Updater {
    private final PsiElementFactory factory;
    protected C element;

    public PassiveViewUpdater(Settings settings, C element, File file) {
        super(settings, file);
        this.factory = JavaPsiFacade.getElementFactory((Project)settings.project());
        this.element = element;
    }

    @Override
    public void update() {
        if (!(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)this.file;
        PsiClass psiClass = javaFile.getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.settings.project(), () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        for (PassiveView.Request request : ((PassiveView)((Object)this.element)).requestList()) {
            if (this.methodOf(request, psiClass) != null) continue;
            this.addMethod(psiClass, request);
        }
    }

    private void addMethod(PsiClass psiClass, PassiveView.Request request) {
        String methodText = Formatters.customize(new DisplayTemplate()).render((Object)PassiveViewRenderer.frameOf(this.element, request, this.settings.packageName()));
        psiClass.addAfter((PsiElement)this.factory.createMethodFromText(methodText, (PsiElement)psiClass), (PsiElement)psiClass.getMethods()[psiClass.getMethods().length - 1]);
    }

    private PsiMethod methodOf(PassiveView.Request request, PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getName().equals(this.nameOf(request))) continue;
            return psiMethod;
        }
        return null;
    }

    private String nameOf(PassiveView.Request request) {
        return Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)request.name$()).toString());
    }
}

