/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui;

import com.intellij.openapi.diagnostic.Logger;
import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public abstract class ElementRenderer<C extends Layer>
extends UIRenderer {
    protected final C element;
    protected final TemplateProvider templateProvider;

    protected ElementRenderer(Settings settings, C element, TemplateProvider templateProvider, Target target) {
        super(settings, target);
        this.element = element;
        this.templateProvider = templateProvider;
    }

    @Override
    public void execute() {
        if (this.isRendered((Layer)this.element)) {
            return;
        }
        super.execute();
        this.saveRendered((Layer)this.element);
    }

    protected final void write(FrameBuilder builder) {
        this.writeSrc(builder);
        this.writeGen(builder);
    }

    private void writeSrc(FrameBuilder builder) {
        String newDisplay = CodeGenerationHelper.displayFilename(this.element.name$(), builder.is("accessible") ? "Proxy" : "");
        Template template = this.srcTemplate(builder);
        String type = this.typeOf((Layer)this.element);
        if (template == null) {
            return;
        }
        File sourceFile = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (!sourceFile.exists()) {
            this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), newDisplay, template.render((Object)builder.toFrame()));
        } else {
            Updater updater = this.updater(newDisplay, sourceFile);
            if (updater != null) {
                updater.update();
            }
        }
    }

    private void writeGen(FrameBuilder builder) {
        String suffix;
        Template template = this.genTemplate(builder);
        String type = this.typeOf((Layer)this.element);
        if (template == null) {
            return;
        }
        String string = suffix = builder.is("accessible") ? "Proxy" : "";
        String abstractValue = builder.is("accessible") ? "" : (ElementHelper.isRoot(this.element) ? "Abstract" : "");
        String newDisplay = CodeGenerationHelper.displayFilename(StringHelper.snakeCaseToCamelCase((String)(abstractValue + Commons.firstUpperCase(this.element.name$()))), suffix);
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), newDisplay, template.render((Object)builder.add("gen").toFrame()));
    }

    public void writeFrame(File packageFolder, String name, String text) {
        try {
            packageFolder.mkdirs();
            File file = CodeGenerationHelper.fileOf(packageFolder, name, this.target);
            Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getInstance((String)"Konos: ").error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract Updater updater(String var1, File var2);

    private Template srcTemplate(FrameBuilder builder) {
        return this.templateProvider.srcTemplate((Layer)this.element, builder);
    }

    private Template genTemplate(FrameBuilder builder) {
        return this.templateProvider.genTemplate((Layer)this.element, builder);
    }
}

