/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.messaging;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.MessagingRequestActionRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MessagingRequestRenderer
extends Renderer {
    private static final String REQUESTS = "requests";
    private final List<Service.Messaging> services;

    public MessagingRequestRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.services = graph.serviceList(Service::isMessaging).map(Service::asMessaging).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(Service.Messaging service) {
        service.core$().findNode(Service.Messaging.Request.class).forEach(this::processRequest);
    }

    private void processRequest(Service.Messaging.Request request) {
        if (!request.isProcessTrigger()) {
            Commons.writeFrame(new File(this.gen(), REQUESTS), StringHelper.snakeCaseToCamelCase((String)request.name$()) + "Request", this.template().render((Object)this.fillRequestFrame(request)));
        }
        this.createCorrespondingAction(request);
    }

    private void createCorrespondingAction(Service.Messaging.Request request) {
        new MessagingRequestActionRenderer(this.settings, request).execute();
    }

    private Frame fillRequestFrame(Service.Messaging.Request request) {
        String returnType = Commons.returnType(request.response());
        Frame[] parameters = this.parameters(request.parameterList());
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("call", (Object)this.call(returnType, parameters));
        if (parameters.length > 0) {
            builder.add("parameter", (Object)parameters);
        }
        if (!returnType.equals("void")) {
            builder.add("returnType", (Object)returnType).add("returnMessageType", (Object)this.messageType(request.response()));
        }
        if (!request.exceptionList().isEmpty() || !request.exceptionRefs().isEmpty()) {
            builder.add("exception", (Object)"");
        }
        if (!request.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        return builder.toFrame();
    }

    @NotNull
    private Frame call(String returnType, Frame[] parameters) {
        FrameBuilder builder = new FrameBuilder(new String[]{returnType, "call"});
        if (parameters.length > 0) {
            builder.add("parameter", (Object)parameters);
        }
        Frame frame = builder.toFrame();
        if (frame == null) {
            MessagingRequestRenderer.$$$reportNull$$$0(0);
        }
        return frame;
    }

    private String messageType(Response response) {
        return response.isFile() ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()});
        if (parameter.isList()) {
            builder.add("List");
        }
        return builder.add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Template template() {
        return Formatters.customize(new MessagingRequestTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/messaging/MessagingRequestRenderer", "call"));
    }
}

