/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.subscriber;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Subscriber;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SubscriberRenderer {
    private final Settings settings;
    private final List<Subscriber> subscribers;
    private final File srcSubscribers;

    public SubscriberRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.subscribers = graph.subscriberList();
        this.srcSubscribers = new File(settings.src(Target.Owner), "subscribers");
    }

    public void execute() {
        for (Subscriber subscriber : this.subscribers) {
            FrameBuilder builder = this.baseFrame(subscriber);
            Settings.DataHubManifest manifest = this.settings.dataHubManifest();
            if (manifest == null) {
                return;
            }
            String type = manifest.tankClasses.get(subscriber.tank());
            if (type == null) {
                return;
            }
            builder.add("type", (Object)type);
            builder.add("typeName", (Object)type.substring(type.lastIndexOf(".") + 1));
            this.settings.classes().put(((Object)((Object)subscriber)).getClass().getSimpleName() + "#" + subscriber.name$(), "subscribers." + subscriber.name$());
            if (this.alreadyRendered(this.srcSubscribers, subscriber.name$())) continue;
            Commons.writeFrame(this.srcSubscribers, subscriber.name$(), Formatters.customize(new SubscriberTemplate()).render((Object)builder.toFrame()));
        }
    }

    @NotNull
    private FrameBuilder baseFrame(Subscriber subscriber) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"subscriber"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName()).add("name", (Object)subscriber.name$());
        if (frameBuilder == null) {
            SubscriberRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/datahub/subscriber/SubscriberRenderer", "baseFrame"));
    }
}

