/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.messagehub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import java.io.File;

public class MessageHubRenderer {
    private final Settings settings;
    private final KonosGraph graph;
    private final File sourceDirectory;
    private final File genDirectory;

    public MessageHubRenderer(Settings settings, KonosGraph graph) {
        this.graph = graph;
        this.settings = settings;
        this.sourceDirectory = settings.src(Target.Owner);
        this.genDirectory = settings.gen(Target.Owner);
    }

    public void execute() {
        File destination;
        MessageHub terminal = this.graph.messageHub();
        if (terminal == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messageHub"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName());
        if (terminal.isJmsBus()) {
            builder.add("jms");
        }
        this.settings.classes().put("MessageHub", "MessageHub");
        File file = destination = terminal.isJmsBus() ? this.genDirectory : this.sourceDirectory;
        if (!Commons.javaFile(destination, "MessageHub").exists()) {
            Commons.writeFrame(destination, "MessageHub", Formatters.customize(new MessageHubTemplate()).render((Object)builder.toFrame()));
        }
    }
}

