/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.messaging;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.messaging.MessagingAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Workflow;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessagingAccessorRenderer
extends Renderer {
    private final Service.Messaging service;
    private final Workflow workflow;
    private File destination;

    public MessagingAccessorRenderer(Settings settings, Service.Messaging application, Workflow workflow, File destination) {
        super(settings, Target.Owner);
        this.service = application;
        this.workflow = workflow;
        this.destination = destination;
    }

    @Override
    public void render() {
        new SchemaListRenderer(this.settings, this.service.graph(), this.destination).execute();
        this.processService(this.service);
    }

    private void processService(Service.Messaging jmsService) {
        List requests;
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        builder.add("name", (Object)jmsService.name$());
        builder.add("package", (Object)this.packageName());
        if (this.workflow != null) {
            builder.add("businessUnit", (Object)this.workflow.businessUnit());
        }
        if (!jmsService.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        if ((requests = jmsService.core$().findNode(Service.Messaging.Request.class)).stream().anyMatch(Service.Messaging.Request::isProcessTrigger)) {
            builder.add("hasProcess", (Object)";");
        }
        Set<String> customParameters = this.extractCustomParameters(requests);
        builder.add("request", requests.stream().map(request -> this.processRequest((Service.Messaging.Request)((Object)request), customParameters).toFrame()).toArray(Frame[]::new));
        for (String parameter : customParameters) {
            builder.add("custom", (Object)parameter);
        }
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)jmsService.name$()) + "Accessor", this.getTemplate().render((Object)builder.toFrame()));
    }

    private Set<String> extractCustomParameters(List<Service.Messaging.Request> requests) {
        HashSet<String> set = new HashSet<String>();
        for (Service.Messaging.Request request : requests) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private FrameBuilder processRequest(Service.Messaging.Request request, Set<String> customParameters) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("queue", (Object)request.path()).add("parameter", (Object)this.parameters(request.parameterList())).add("messageType", (Object)this.messageType(request.parameterList()));
        if (request.response() != null && request.response().isType()) {
            builder.add("reply");
            FrameBuilder reply = new FrameBuilder();
            if (request.response().isList()) {
                reply.add("list");
            }
            builder.add("reply", (Object)reply.add("reply").add(((Object)((Object)request.response().asType())).getClass().getSimpleName()).add("value", (Object)request.response().asType().type()));
        }
        customParameters.forEach(parameter -> builder.add("custom", parameter));
        return builder;
    }

    private String messageType(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isFile()) continue;
            return "Bytes";
        }
        return "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Template getTemplate() {
        return new MessagingAccessorTemplate().add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString())).add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value).add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

