/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.google.gson.Gson;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.plugin.dependencyresolution.DependencyCatalog;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Settings {
    private Project project;
    private Module module;
    private LegioConfiguration moduleConfiguration;
    private DataHubManifest dataHubManifest;
    private Module webModule;
    private String parent;
    private File res;
    private File src;
    private File gen;
    private ElementCache cache;
    private String packageName;
    private String boxName = null;
    private Map<String, String> classes = new HashMap<String, String>();

    public Settings() {
    }

    public Settings(Module module, File src, File gen, File res, String packageName, ElementCache cache) {
        this.project(module == null ? null : module.getProject());
        this.module(module);
        this.moduleConfiguration(TaraUtil.configurationOf((Module)module));
        this.res(res);
        this.src(src);
        this.gen(gen);
        this.packageName(packageName);
        this.cache(cache);
        this.loadManifest();
    }

    public Project project() {
        return this.project;
    }

    public Settings project(Project project) {
        this.project = project;
        return this;
    }

    public Module module() {
        return this.module;
    }

    public Settings module(Module module) {
        this.module = module;
        return this;
    }

    public Module webModule() {
        return this.webModule;
    }

    public Settings webModule(Module module) {
        this.webModule = module;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public Settings parent(String parent) {
        this.parent = parent;
        return this;
    }

    public File root(Target target) {
        String rootDir = target == Target.Owner ? this.module().getModuleFilePath() : this.webModule().getModuleFilePath();
        return CodeGenerationHelper.createIfNotExists(new File(rootDir).getParentFile());
    }

    public File res(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.res : this.accessorRes());
    }

    public Settings res(File res) {
        this.res = res;
        return this;
    }

    public File src(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.src : this.accessorSrc());
    }

    public Settings src(File src) {
        this.src = src;
        return this;
    }

    public File gen(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.gen : this.accessorGen());
    }

    public Settings gen(File gen) {
        this.gen = gen;
        return this;
    }

    public ElementCache cache() {
        return this.cache;
    }

    public Settings cache(ElementCache cache) {
        this.cache = cache;
        return this;
    }

    public String packageName() {
        return this.packageName;
    }

    public Settings packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String boxName() {
        if (this.boxName == null) {
            this.boxName = StringHelper.snakeCaseToCamelCase((String)(this.moduleConfiguration != null ? this.moduleConfiguration.artifactId() : Configuration.Model.Level.Solution.name()));
        }
        return this.boxName;
    }

    public LegioConfiguration moduleConfiguration() {
        return this.moduleConfiguration;
    }

    public DataHubManifest dataHubManifest() {
        return this.dataHubManifest;
    }

    public Map<String, String> classes() {
        return this.classes;
    }

    public Settings classes(Map<String, String> classes) {
        this.classes = classes;
        return this;
    }

    private void moduleConfiguration(Configuration configuration) {
        this.moduleConfiguration = configuration instanceof LegioConfiguration ? (LegioConfiguration)configuration : null;
    }

    private File accessorRes() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "res"));
    }

    private File accessorSrc() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "src"));
    }

    private File accessorGen() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "gen"));
    }

    private void loadManifest() {
        this.dataHubManifest = this.moduleConfiguration() != null ? this.loadManifest(this.moduleConfiguration().dataHub()) : null;
    }

    private DataHubManifest loadManifest(DependencyCatalog.Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        try {
            File jar = dependency.jar();
            ZipFile zipFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals("terminal.mf")) continue;
                return (DataHubManifest)new Gson().fromJson(new String(zipFile.getInputStream(entry).readAllBytes()), DataHubManifest.class);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return null;
    }

    public Settings clone() {
        Settings result = new Settings(this.module, this.src, this.gen, this.res, this.packageName, this.cache);
        result.webModule = this.webModule;
        result.parent = this.parent;
        result.classes = this.classes;
        return result;
    }

    public String graphName() {
        Object result = this.project != null ? this.project.getName() : "";
        result = (String)result + (this.module != null ? this.module.getName() : "");
        return !((String)result).isEmpty() ? result : "test";
    }

    public static class DataHubManifest {
        public String terminal;
        public String qn;
        public List<String> parameters;
        public List<String> publish;
        public List<String> subscribe;
        public Map<String, String> tankClasses;
        public Map<String, List<String>> messageContexts;
    }
}

