/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ParameterPublisher;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datalake;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Subscriber;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractBoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private final Configuration configuration;
    private final boolean hasModel;
    private final Set<String> konosParameters;

    AbstractBoxRenderer(Settings settings, KonosGraph graph, boolean hasModel) {
        super(settings, Target.Owner);
        this.graph = graph;
        this.configuration = this.module() != null ? TaraUtil.configurationOf((Module)this.module()) : null;
        this.hasModel = hasModel;
        this.konosParameters = new HashSet<String>();
        this.konosParameters.add("home");
    }

    @Override
    public void render() {
        FrameBuilder root = new FrameBuilder(new String[]{"box"});
        root.add("name", (Object)this.boxName()).add("package", (Object)this.packageName());
        this.parent(root);
        this.services(root);
        this.sentinels(root);
        this.datalake(root);
        this.messageHub(root);
        this.terminal(root);
        this.workflow(root);
        if (this.hasAuthenticatedApis()) {
            root.add("authenticationValidator", (Object)new FrameBuilder().add("type", (Object)"Basic"));
        }
        this.graph.datamartList().forEach(d -> this.datamart(root, (Datamart)((Object)d)));
        Commons.writeFrame(this.settings.gen(Target.Owner), "AbstractBox", this.template().render((Object)root.toFrame()));
        this.notifyNewParameters();
    }

    Set<String> customParameters() {
        return this.konosParameters;
    }

    private void datamart(FrameBuilder root, Datamart datamart) {
        root.add("datamart", (Object)new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("path", (Object)this.parameter(datamart.name$(), new String[0])));
    }

    private void notifyNewParameters() {
        new ParameterPublisher((LegioConfiguration)this.configuration).publish(this.konosParameters);
    }

    private void sentinels(FrameBuilder builder) {
        if (!this.graph.sentinelList().isEmpty()) {
            builder.add("sentinel", (Object)new FrameBuilder(new String[]{"sentinel"}).add("configuration", (Object)this.boxName()).toFrame());
        }
    }

    private void datalake(FrameBuilder root) {
        Datalake datalake = this.graph.datalake();
        if (datalake == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"datalake", datalake.isLocal() ? "Local" : "Mirror"});
        builder.add("package", (Object)this.packageName());
        builder.add("path", (Object)this.parameter(datalake.path(), new String[0]));
        if (datalake.isSshMirrored()) {
            Datalake.SshMirrored mirror = datalake.asSshMirrored();
            builder.add("parameter", (Object)this.parameter(mirror.url(), new String[0])).add("parameter", (Object)this.parameter(mirror.user(), new String[0])).add("parameter", (Object)this.parameter(mirror.password(), new String[0])).add("parameter", (Object)this.parameter(mirror.originDatalakePath(), new String[0])).add("parameter", (Object)this.parameter(mirror.startingTimetag(), new String[0]));
        } else if (datalake.isNfsMirrored()) {
            builder.add("parameter", (Object)this.parameter(datalake.asNfsMirrored().originDatalakePath(), new String[0])).add("parameter", (Object)this.parameter(datalake.asNfsMirrored().startingTimetag(), new String[0]));
        }
        root.add("datalake", (Object)builder);
    }

    private void terminal(FrameBuilder root) {
        Settings.DataHubManifest manifest = this.settings.dataHubManifest();
        if (manifest == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("name", (Object)manifest.terminal).add("qn", (Object)manifest.qn).add("package", (Object)this.packageName()).add("box", (Object)this.boxName());
        manifest.parameters.forEach(p -> builder.add("parameter", (Object)this.parameter((String)p, "conf", p.contains("directory") ? "file" : "standard")));
        Frame[] subscriber = (Frame[])this.graph.subscriberList().stream().filter(s -> manifest.tankClasses.containsKey(s.tank())).map(s -> this.subscriberFramesOf((Subscriber)((Object)s), manifest)).flatMap(Collection::stream).map(FrameBuilder::toFrame).toArray(Frame[]::new);
        if (subscriber.length != 0) {
            builder.add("subscriber", (Object)subscriber);
        }
        root.add("terminal", (Object)builder.toFrame());
    }

    private List<FrameBuilder> subscriberFramesOf(Subscriber subscriber, Settings.DataHubManifest manifest) {
        String tankClass = manifest.tankClasses.get(subscriber.tank());
        if (subscriber.context() != null) {
            FrameBuilder builder = this.subscriberFrame(subscriber, manifest);
            this.contextFrame(tankClass, builder, subscriber.context());
            return Collections.singletonList(builder);
        }
        ArrayList<FrameBuilder> builders = new ArrayList<FrameBuilder>();
        if (manifest.messageContexts.get(subscriber.tank()).size() > 1) {
            for (String context : manifest.messageContexts.get(subscriber.tank())) {
                FrameBuilder builder = this.subscriberFrame(subscriber, manifest);
                this.contextFrame(tankClass, builder, context);
                builders.add(builder);
            }
        } else {
            builders.add(this.subscriberFrame(subscriber, manifest));
        }
        return builders;
    }

    @NotNull
    private FrameBuilder subscriberFrame(Subscriber subscriber, Settings.DataHubManifest manifest) {
        FrameBuilder builder = new FrameBuilder(new String[]{"subscriber", "terminal"}).add("package", (Object)this.packageName()).add("name", (Object)subscriber.name$()).add("box", (Object)this.boxName()).add("terminal", (Object)manifest.qn).add("tank", (Object)subscriber.tank());
        if (subscriber.subscriberId() != null) {
            builder.add("subscriberId", (Object)subscriber.subscriberId());
        }
        FrameBuilder frameBuilder = builder;
        if (frameBuilder == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private void contextFrame(String tankClass, FrameBuilder builder, String context) {
        builder.add("context", (Object)new FrameBuilder(new String[]{"context"}).add("value", (Object)Formatters.snakeCaseToCamelCase().format((Object)context.replace(".", "-")).toString()).add("type", (Object)tankClass).toFrame());
    }

    private void messageHub(FrameBuilder root) {
        Frame[] mounterFrames;
        MessageHub hub = this.graph.messageHub();
        if (hub == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messagehub"});
        if (hub.isJmsBus()) {
            MessageHub.JmsBus jmsHub = hub.asJmsBus();
            builder.add("jms").add("parameter", (Object)this.parameter(jmsHub.url(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.user(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.password(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.clientId(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.outBoxDirectory(), new String[0]));
        }
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        Frame[] feederFrames = (Frame[])this.graph.feederList().stream().filter(f -> !f.sensorList().isEmpty()).map(this::frameOf).toArray(Frame[]::new);
        if (feederFrames.length != 0) {
            builder.add("feeder", (Object)feederFrames);
        }
        if ((mounterFrames = (Frame[])this.graph.subscriberList().stream().map(s -> this.frameOf((Subscriber)((Object)s)).add("messageHub").toFrame()).toArray(Frame[]::new)).length != 0) {
            builder.add("mounter", (Object)mounterFrames);
        }
        root.add("messagehub", (Object)builder.toFrame());
    }

    private void workflow(FrameBuilder root) {
        if (this.graph.workflow() == null || this.graph.workflow().processList().isEmpty()) {
            return;
        }
        root.add("workflow", (Object)this.buildBaseFrame().add("workflow"));
        this.konosParameters.add("home");
    }

    private FrameBuilder frameOf(Subscriber subscriber) {
        FrameBuilder builder = new FrameBuilder(new String[]{"subscriber"}).add("package", (Object)this.packageName()).add("name", (Object)subscriber.name$()).add("source", (Object)subscriber.tank());
        if (subscriber.subscriberId() != null) {
            builder.add("subscriberId", (Object)subscriber.subscriberId());
        }
        return builder.add("box", (Object)this.boxName());
    }

    @NotNull
    private FrameBuilder parameter(String parameter, String ... types) {
        FrameBuilder frameBuilder = new FrameBuilder(types).add("parameter").add(this.isCustom(parameter) ? "custom" : "standard").add("value", (Object)parameter);
        if (frameBuilder == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(1);
        }
        return frameBuilder;
    }

    @NotNull
    private Frame parameter(Service.SlackBot service) {
        Frame frame = new FrameBuilder(new String[]{this.isCustom(service.token()) ? "custom" : "standard"}).add("value", (Object)service.token()).toFrame();
        if (frame == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(2);
        }
        return frame;
    }

    private Frame frameOf(Feeder feeder) {
        return new FrameBuilder(new String[]{"feeder"}).add("package", (Object)this.packageName()).add("name", (Object)feeder.name$()).add("box", (Object)this.boxName()).toFrame();
    }

    private void services(FrameBuilder builder) {
        if (!this.graph.messagingServiceList().isEmpty()) {
            builder.add("jms", (Object)"");
        }
        this.rest(builder);
        this.jms(builder);
        this.jmx(builder);
        this.slackServices(builder);
        if (!this.graph.restServiceList().isEmpty() || !this.graph.uiServiceList().isEmpty()) {
            builder.add("spark", (Object)"stop");
        }
        this.ui(builder);
    }

    private void rest(FrameBuilder frame) {
        for (Service.REST service : this.graph.restServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "rest"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private boolean hasAuthenticatedApis() {
        return this.graph.restServiceList().stream().anyMatch(restService -> restService.authenticatedWithToken() != null);
    }

    private void jms(FrameBuilder frame) {
        for (Service.Messaging service : this.graph.messagingServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jms"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()));
        }
    }

    private void jmx(FrameBuilder frame) {
        for (Service.JMX service : this.graph.jmxServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jmx"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).toFrame());
        }
    }

    private void slackServices(FrameBuilder frame) {
        for (Service.SlackBot service : this.graph.slackBotServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "slack"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service)).toFrame());
        }
    }

    private void ui(FrameBuilder builder) {
        if (!this.graph.uiServiceList().isEmpty()) {
            FrameBuilder uiFrame = new FrameBuilder().add("package", (Object)this.packageName());
            if (this.settings.parent() != null) {
                uiFrame.add("parent", (Object)this.settings.parent());
            }
            builder.add("hasUi", (Object)uiFrame);
            builder.add("uiAuthentication", (Object)uiFrame);
            builder.add("uiEdition", (Object)uiFrame);
            builder.add("service", this.graph.uiServiceList().stream().map(s -> this.ui((Service.UI)((Object)s), this.boxName())).toArray(Frame[]::new));
        }
    }

    private Frame ui(Service.UI service, String name) {
        FrameBuilder builder = new FrameBuilder(new String[]{"service", "ui"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0]).toFrame()).add("package", (Object)this.packageName());
        if (service.authentication() != null) {
            builder.add("authentication", (Object)this.parameter(service.authentication().by(), new String[0]).toFrame());
        }
        if (service.edition() != null) {
            builder.add("edition", (Object)new FrameBuilder(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).add("value", (Object)service.edition().by()).toFrame());
        }
        service.useList().forEach(use -> builder.add("use", (Object)(use.className() + "Service")));
        return builder.toFrame();
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.konosParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(FrameBuilder builder) {
        if (this.parent() != null && this.configuration != null && this.configuration.model() != null && !this.configuration.model().level().isPlatform()) {
            builder.add("parent", (Object)this.parent()).add("hasParent", (Object)"");
        } else {
            builder.add("hasntParent", (Object)"");
        }
    }

    private Template template() {
        return Formatters.customize(new AbstractBoxTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/intino/konos/builder/codegeneration/AbstractBoxRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "subscriberFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parameter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

