/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Sentinel
extends Layer
implements Terminal {
    protected SentinelAspect _sentinelAspect;
    protected SystemListener _systemListener;
    protected ClockListener _clockListener;
    protected BootListener _bootListener;
    protected ShutdownListener _shutdownListener;
    protected DirectoryListener _directoryListener;
    protected MailListener _mailListener;

    public Sentinel(Node node) {
        super(node);
    }

    public ShutdownListener asShutdownListener() {
        Layer as = this.a$(ShutdownListener.class);
        return as != null ? (ShutdownListener)as : (ShutdownListener)this.core$().addAspect(ShutdownListener.class);
    }

    public boolean isShutdownListener() {
        return this.core$().is(ShutdownListener.class);
    }

    public SystemListener asSystemListener() {
        Layer as = this.a$(SystemListener.class);
        return as != null ? (SystemListener)as : (SystemListener)this.core$().addAspect(SystemListener.class);
    }

    public boolean isSystemListener() {
        return this.core$().is(SystemListener.class);
    }

    public ClockListener asClockListener() {
        return (ClockListener)this.a$(ClockListener.class);
    }

    public ClockListener asClockListener(String pattern) {
        ClockListener newElement = (ClockListener)this.core$().addAspect(ClockListener.class);
        newElement.core$().set((Layer)newElement, "pattern", Collections.singletonList(pattern));
        return newElement;
    }

    public boolean isClockListener() {
        return this.core$().is(ClockListener.class);
    }

    public void removeClockListener() {
        this.core$().removeAspect(ClockListener.class);
    }

    public SentinelAspect asSentinelAspect() {
        Layer as = this.a$(SentinelAspect.class);
        return as != null ? (SentinelAspect)as : (SentinelAspect)this.core$().addAspect(SentinelAspect.class);
    }

    public boolean isSentinelAspect() {
        return this.core$().is(SentinelAspect.class);
    }

    public MailListener asMailListener() {
        Layer as = this.a$(MailListener.class);
        return as != null ? (MailListener)as : (MailListener)this.core$().addAspect(MailListener.class);
    }

    public boolean isMailListener() {
        return this.core$().is(MailListener.class);
    }

    public DirectoryListener asDirectoryListener() {
        return (DirectoryListener)this.a$(DirectoryListener.class);
    }

    public DirectoryListener asDirectoryListener(List<String> directories, List<DirectoryListener.Events> events) {
        DirectoryListener newElement = (DirectoryListener)this.core$().addAspect(DirectoryListener.class);
        newElement.core$().set((Layer)newElement, "directories", directories);
        newElement.core$().set((Layer)newElement, "events", events);
        return newElement;
    }

    public boolean isDirectoryListener() {
        return this.core$().is(DirectoryListener.class);
    }

    public void removeDirectoryListener() {
        this.core$().removeAspect(DirectoryListener.class);
    }

    public BootListener asBootListener() {
        Layer as = this.a$(BootListener.class);
        return as != null ? (BootListener)as : (BootListener)this.core$().addAspect(BootListener.class);
    }

    public boolean isBootListener() {
        return this.core$().is(BootListener.class);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class MailListener
    extends SentinelAspect
    implements Terminal {
        public MailListener(Node node) {
            super(node);
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class DirectoryListener
    extends SentinelAspect
    implements Terminal {
        protected List<String> directories = new ArrayList<String>();
        protected List<Events> events = new ArrayList<Events>();

        public DirectoryListener(Node node) {
            super(node);
        }

        public List<String> directories() {
            return this.directories;
        }

        public String directories(int index) {
            return this.directories.get(index);
        }

        public List<String> directories(Predicate<String> predicate) {
            return this.directories().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Events> events() {
            return this.events;
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("directories", this.directories);
            map.put("events", this.events);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("directories")) {
                this.directories = StringLoader.load(values, (Layer)this);
            } else if (name.equalsIgnoreCase("events")) {
                this.events = WordLoader.load(values, Events.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("directories")) {
                this.directories = new ArrayList(values);
            } else if (name.equalsIgnoreCase("events")) {
                this.events = new ArrayList(values);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Events {
            OnCreate,
            OnDelete,
            OnModify;

        }
    }

    public static class ShutdownListener
    extends SystemListener
    implements Terminal {
        public ShutdownListener(Node node) {
            super(node);
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class BootListener
    extends SystemListener
    implements Terminal {
        protected int delay;

        public BootListener(Node node) {
            super(node);
        }

        public int delay() {
            return this.delay;
        }

        public BootListener delay(int value) {
            this.delay = value;
            return this;
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("delay", new ArrayList<Integer>(Collections.singletonList(this.delay)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("delay")) {
                this.delay = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("delay")) {
                this.delay = (Integer)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class ClockListener
    extends SystemListener
    implements Terminal {
        protected String pattern;
        protected String mean;
        protected String timeZone;

        public ClockListener(Node node) {
            super(node);
        }

        public String pattern() {
            return this.pattern;
        }

        public String mean() {
            return this.mean;
        }

        public String timeZone() {
            return this.timeZone;
        }

        public ClockListener pattern(String value) {
            this.pattern = value;
            return this;
        }

        public ClockListener mean(String value) {
            this.mean = value;
            return this;
        }

        public ClockListener timeZone(String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
            map.put("mean", new ArrayList<String>(Collections.singletonList(this.mean)));
            map.put("timeZone", new ArrayList<String>(Collections.singletonList(this.timeZone)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mean")) {
                this.mean = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("timeZone")) {
                this.timeZone = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mean")) {
                this.mean = (String)values.get(0);
            } else if (name.equalsIgnoreCase("timeZone")) {
                this.timeZone = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class SystemListener
    extends SentinelAspect
    implements Terminal {
        public SystemListener(Node node) {
            super(node);
        }

        @Override
        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._sentinel.core$().load((Layer)this._sentinel, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._sentinel.core$().set((Layer)this._sentinel, name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class SentinelAspect
    extends Layer
    implements Terminal {
        protected Sentinel _sentinel;

        public SentinelAspect(Node node) {
            super(node);
        }

        public Sentinel asSentinel() {
            return (Sentinel)this.a$(Sentinel.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Sentinel) {
                this._sentinel = (Sentinel)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

