/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.List;

public class PageRenderer
extends ActionRenderer {
    private final Settings settings;
    private final Service.UI.Resource resource;
    private final Service.UI service;

    public PageRenderer(Settings settings, Service.UI.Resource resource) {
        super(settings, "ui");
        this.settings = settings;
        this.resource = resource;
        this.service = (Service.UI)resource.core$().ownerAs(Service.UI.class);
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder().add("action").add("ui");
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        builder.add("name", (Object)this.resource.name$());
        builder.add("uiService", (Object)uiService.name$());
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        builder.add("importTemplates", (Object)this.packageName());
        builder.add("component", (Object)this.componentFrame());
        builder.add("parameter", (Object)this.parameters());
        builder.add("contextProperty", (Object)this.contextPropertyFrame());
        this.service.useList().forEach(use -> builder.add("usedUnit", (Object)this.usedUnitFrame((Service.UI.Use)((Object)use))));
        if (this.service.favicon() != null) {
            builder.add("favicon", (Object)this.service.favicon());
        } else if (this.service.title() != null) {
            builder.add("title", (Object)this.service.title());
        }
        this.settings.classes().put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + this.firstUpperCase(this.resource.core$().name()), "actions." + this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + this.suffix());
        if (!this.alreadyRendered(this.src(), this.resource.name$())) {
            Commons.writeFrame(this.destinyPackage(this.src()), this.resource.name$() + this.suffix(), this.template().render((Object)builder.toFrame()));
        }
        Commons.writeFrame(this.destinyPackage(this.gen()), "Abstract" + this.firstUpperCase(this.resource.name$()) + this.suffix(), this.template().render((Object)builder.add("gen").toFrame()));
    }

    @Override
    protected ActionRenderer.ContextType contextType() {
        return ActionRenderer.ContextType.Spark;
    }

    private Frame usedUnitFrame(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"usedUnit"});
        result.add(this.isCustom(use.url()) ? "custom" : "standard");
        result.add("name", (Object)use.name$());
        result.add("url", (Object)(this.isCustom(use.url()) ? this.customValue(use.url()) : use.url()));
        return result.toFrame();
    }

    private FrameBuilder componentFrame() {
        return new FrameBuilder(new String[]{"component"}).add("value", (Object)KonosGraph.templateFor(this.resource).name$());
    }

    private FrameBuilder[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("type", (Object)"String").add("name", parameter)).toArray(FrameBuilder[]::new);
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private String customValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }

    @Override
    protected File destinyPackage(File destiny) {
        return new File(destiny, CodeGenerationHelper.format("%spages", Target.Owner));
    }

    @Override
    protected String suffix() {
        return "Page";
    }
}

