/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.alexandria.logger.Logger;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.mounter.IMounterTemplate;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MounterFactoryRenderer {
    private final Settings settings;
    private final List<Datamart.Mounter> mounters;
    private File genMounters;

    public MounterFactoryRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.mounters = graph.datamartList().stream().map(Datamart::mounterList).flatMap(Collection::stream).collect(Collectors.toList());
        this.genMounters = new File(settings.gen(Target.Owner), "mounters");
    }

    public void execute() {
        Logger.info((String)"Mounter factory");
        if (this.mounters.isEmpty()) {
            Logger.error((String)"no mounters");
            return;
        }
        Logger.info((String)"Mounter factory2");
        Settings.DataHubManifest manifest = this.settings.dataHubManifest();
        if (manifest == null) {
            return;
        }
        FrameBuilder builder = this.baseFrame("factory");
        Map<String, List<Datamart.Mounter>> map = this.map(this.mounters, manifest);
        for (String event : map.keySet()) {
            builder.add("event", (Object)this.baseFrame("event").add("name", (Object)event).add("mounter", map.get(event).stream().map(m -> this.baseFrame("mounter").add("datamart", (Object)m.core$().owner().name()).add("name", (Object)m.name$()).toFrame()).toArray(Frame[]::new)));
        }
        this.settings.classes().put(Datamart.Mounter.class.getSimpleName() + "#MounterFactory", "mounters.mounterFactory");
        Frame object = builder.toFrame();
        Commons.writeFrame(this.genMounters, "MounterFactory", Formatters.customize(new MounterFactoryTemplate()).render((Object)object));
        Commons.writeFrame(this.genMounters, "Mounter", Formatters.customize(new IMounterTemplate()).render((Object)object));
    }

    private Map<String, List<Datamart.Mounter>> map(List<Datamart.Mounter> mounters, Settings.DataHubManifest manifest) {
        HashMap<String, List<Datamart.Mounter>> mountersByRequire = new HashMap<String, List<Datamart.Mounter>>();
        for (Datamart.Mounter mounter : mounters) {
            mounter.asEvent().requireList().forEach(r -> {
                String key = manifest.tankClasses.get(r.tank());
                if (!mountersByRequire.containsKey(key)) {
                    mountersByRequire.put(key, new ArrayList());
                }
                ((List)mountersByRequire.get(key)).add(mounter);
            });
        }
        return mountersByRequire;
    }

    @NotNull
    private FrameBuilder baseFrame(String name) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{name}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName());
        if (frameBuilder == null) {
            MounterFactoryRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/datahub/mounter/MounterFactoryRenderer", "baseFrame"));
    }
}

