/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.adapter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Adapter;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;

public class AdapterRenderer {
    private final Settings settings;
    private final List<Adapter> adapters;

    public AdapterRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.adapters = graph.adapterList();
    }

    public void execute() {
        for (Adapter adapter : this.adapters) {
            FrameBuilder builder = new FrameBuilder(new String[]{"adapter"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName()).add("name", (Object)adapter.name$());
            File directory = new File(this.settings.src(Target.Owner), "adapters");
            String adapterName = adapter.name$();
            this.settings.classes().put(((Object)((Object)adapter)).getClass().getSimpleName() + "#" + adapter.name$(), "adapters." + adapterName);
            if (this.alreadyRendered(directory, adapterName)) continue;
            Commons.writeFrame(directory, adapterName, Formatters.customize(new AdapterTemplate()).render((Object)builder.toFrame()));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

