/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public abstract class Cleaner {
    protected final ElementHelper elementHelper;
    protected final Settings settings;
    protected static final List<String> ExcludedDirectories = Arrays.asList("displays", "graph", ".cache");

    public Cleaner(Settings settings) {
        this.settings = settings;
        this.elementHelper = new ElementHelper();
    }

    public abstract void execute();

    protected File res(Target target) {
        return this.settings.res(target);
    }

    protected File src(Target target) {
        return this.settings.src(target);
    }

    protected File gen(Target target) {
        return this.settings.gen(target);
    }

    protected ElementCache cache() {
        return this.settings.cache();
    }

    protected String typeOf(Layer element) {
        return this.elementHelper.typeOf(element);
    }

    protected String nameOf(Layer element) {
        return this.elementHelper.nameOf(element);
    }

    protected void remove(File folder, String name, Target target) {
        File file = CodeGenerationHelper.fileOf(folder, StringHelper.snakeCaseToCamelCase((String)name), target);
        if (file.exists()) {
            file.delete();
        }
    }

    protected void clean(File directory) {
        if (!directory.exists()) {
            return;
        }
        List<File> files = Arrays.asList(directory.listFiles(pathname -> !ExcludedDirectories.contains(pathname.getName())));
        files.forEach(f -> {
            if (f.isDirectory()) {
                this.clean((File)f);
            }
            f.delete();
        });
    }
}

