/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.rules;

import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.rules.NodeRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CheckPath
implements NodeRule {
    private Cause cause;

    public boolean accept(Node node) {
        return !this.pathIsWrong(node);
    }

    private boolean pathIsWrong(Node node) {
        if (this.parameter(node, "path") == null) {
            return false;
        }
        if (this.parameter(node, "path").values().get(0) instanceof EmptyNode) {
            this.cause = Cause.NullPath;
            return true;
        }
        return this.pathIsWrong((String)this.parameter(node, "path").values().get(0), node);
    }

    private boolean pathIsWrong(String pathValue, Node node) {
        if (node == null) {
            return false;
        }
        List parametersInPath = Arrays.stream(pathValue.split("/")).filter(s -> s.startsWith(":")).map(s -> s.substring(1)).collect(Collectors.toList());
        List<String> parametersDeclaredInPath = this.pathParametersFromNode(node);
        parametersDeclaredInPath.addAll(this.pathParametersInMethods(node.components()));
        for (String parameterName : parametersInPath) {
            if (parametersDeclaredInPath.contains(parameterName)) continue;
            this.cause = Cause.ParameterNotDeclared;
            return true;
        }
        for (String parameterName : parametersDeclaredInPath) {
            if (parametersInPath.contains(parameterName)) continue;
            this.cause = Cause.ParameterNotInPath;
            return true;
        }
        return false;
    }

    private List<String> pathParametersFromNode(Node node) {
        return node.components().stream().filter(c -> this.isParameter((Node)c) && this.parameterIsInPath((Node)c)).map(Node::name).collect(Collectors.toList());
    }

    private List<String> pathParametersInMethods(List<Node> methods) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Node component : methods) {
            parameters.addAll(this.pathParametersFromNode(component));
        }
        return parameters;
    }

    private boolean parameterIsInPath(Node node) {
        return "path".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private Parameter parameter(Node node, String name) {
        return node.parameters().stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
    }

    private boolean isParameter(Node component) {
        return component.type().equals("Service.REST.Resource.Parameter");
    }

    public String errorMessage() {
        if (this.cause == Cause.NullPath) {
            return "Path cannot be empty";
        }
        if (this.cause == Cause.ParameterNotDeclared) {
            return "Parameters in path must be declared as \"Parameter\"";
        }
        return "Declared parameter is not visible in resource's path";
    }

    static enum Cause {
        NullPath,
        ParameterNotDeclared,
        ParameterNotInPath;

    }
}

