/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import io.intino.konos.builder.codegeneration.swagger.OpenApiDescriptor;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerProfileGenerator {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private final List<Service.REST> services;
    private final File directory;

    public SwaggerProfileGenerator(List<Service.REST> services, File directory) {
        this.services = services;
        this.directory = directory;
    }

    public void execute() {
        this.services.stream().filter(Service.REST::generateDocs).forEach(service -> this.writeFile((Service.REST)((Object)service), new OpenApiDescriptor((Service.REST)((Object)service)).createJSONDescriptor()));
    }

    private void writeFile(Service.REST service, String json) {
        try {
            Files.write(new File(this.directory, service.name$() + ".json").toPath(), json.getBytes(Charset.forName("UTF-8")), new OpenOption[0]).toFile().getPath();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

