/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.ServiceTemplateProvider;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayListRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.ResourceListRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;

public class ServiceListRenderer
extends UIRenderer {
    private final KonosGraph graph;

    public ServiceListRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.graph = graph;
    }

    @Override
    public void render() {
        this.graph.serviceList(Service::isUI).map(Service::asUI).forEach(this::processUIService);
        new ResourceListRenderer(this.settings, this.graph, Target.Owner).execute();
    }

    private void processUIService(Service.UI service) {
        new ServiceRenderer(this.settings, service).execute();
        new DisplayListRenderer(this.settings, service, this.templateProvider(), this.target).execute();
    }

    private TemplateProvider templateProvider() {
        return new ServiceTemplateProvider();
    }
}

