/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MounterRenderer {
    private final Settings settings;
    private final File sourceMounters;
    private final KonosGraph graph;
    private File genMounters;

    public MounterRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.graph = graph;
        this.sourceMounters = new File(settings.src(Target.Owner), "mounters");
        this.genMounters = new File(settings.gen(Target.Owner), "mounters");
    }

    public void execute() {
        Settings.DataHubManifest manifest = this.settings.dataHubManifest();
        for (Datamart datamart : this.graph.datamartList()) {
            for (Datamart.Mounter mounter : datamart.mounterList()) {
                String mounterName = mounter.name$();
                FrameBuilder builder = this.baseFrame(mounter);
                if (mounter.isPopulation()) {
                    this.populationMounter(mounter, mounterName, builder);
                    continue;
                }
                if (manifest == null || this.alreadyRendered(this.sourceMounters, mounterName)) continue;
                this.eventMounter(mounter, mounterName, manifest, builder);
            }
        }
    }

    @NotNull
    private FrameBuilder baseFrame(Datamart.Mounter mounter) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName()).add("name", (Object)mounter.name$());
        if (frameBuilder == null) {
            MounterRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private void eventMounter(Datamart.Mounter mounter, String mounterName, Settings.DataHubManifest manifest, FrameBuilder builder) {
        String datamart = ((Datamart)mounter.core$().ownerAs(Datamart.class)).name$();
        builder.add("event").add("datamart", (Object)datamart).add("type", (Object)this.types(mounter, manifest));
        this.settings.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + datamart + "." + mounterName);
        Commons.writeFrame(new File(this.sourceMounters, datamart), mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
    }

    private String[] types(Datamart.Mounter mounter, Settings.DataHubManifest manifest) {
        return (String[])mounter.asEvent().requireList().stream().map(r -> manifest.tankClasses.get(r.tank())).filter(Objects::nonNull).toArray(String[]::new);
    }

    private void populationMounter(Datamart.Mounter mounter, String mounterName, FrameBuilder builder) {
        this.populationMounter(builder, mounter.asPopulation());
        this.settings.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + mounterName);
        Commons.writeFrame(this.genMounters, mounter.name$(), Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        this.mounterFunctions(mounter);
    }

    private void mounterFunctions(Datamart.Mounter mounter) {
        mounter.asPopulation().clear().split(t -> true);
        FrameBuilder baseFrame = this.baseFrame(mounter).add("src");
        this.populationMounter(baseFrame, mounter.asPopulation());
        if (!this.alreadyRendered(this.sourceMounters, mounter.name$() + "MounterFunctions")) {
            Commons.writeFrame(this.sourceMounters, mounter.name$() + "MounterFunctions", Formatters.customize(new MounterTemplate()).render((Object)baseFrame.toFrame()));
        }
    }

    private Object name(String tank) {
        return tank.replace(".", " ");
    }

    private void populationMounter(FrameBuilder builder, Datamart.Mounter.Population mounter) {
        ArrayList frames = new ArrayList();
        mounter.sourceList().stream().map(this::buildersOf).forEach(frames::addAll);
        builder.add("population").add("column", (Object)frames.toArray(new FrameBuilder[0])).add("datamart", (Object)((Datamart)mounter.core$().ownerAs(Datamart.class)).name$()).add("format", (Object)mounter.format().name());
    }

    private List<FrameBuilder> buildersOf(Datamart.Mounter.Population.Source source) {
        ArrayList<FrameBuilder> builders = new ArrayList<FrameBuilder>();
        for (String tank : this.tanksOf((Datamart.Mounter.Population)source.core$().ownerAs(Datamart.Mounter.Population.class), source.tank())) {
            FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("fullName", (Object)tank).add("name", (Object)source.tank()).add("type", (Object)source.type().name()).add("mounter", (Object)((Datamart.Mounter)source.core$().ownerAs(Datamart.Mounter.class)).name$());
            if (source.isId()) {
                builder.add("facet", (Object)"id");
            }
            builders.add(builder);
        }
        return builders;
    }

    private List<String> tanksOf(Datamart.Mounter.Population mounter, String tank) {
        ArrayList<String> tanks = new ArrayList<String>();
        if (!mounter.splitList().isEmpty()) {
            for (Datamart.Mounter.Population.Split split : mounter.splitList()) {
                split.splits().stream().map(s -> s + "." + tank).forEach(tanks::add);
            }
        } else {
            return Collections.singletonList(tank);
        }
        return tanks;
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/datahub/mounter/MounterRenderer", "baseFrame"));
    }
}

